/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.core.validation.EloViolation;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoAnexo;
import br.com.elotech.protocolo.domain.ProcessoAnexoPK;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.repository.ProcessoAnexoRepository;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.specs.ProcessoAnexoSpecificationHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessoAnexoService
extends CrudService<ProcessoAnexo, ProcessoAnexoPK> {
    private final ProcessoAnexoRepository processoAnexoRepository;
    private final ProcessoRepository processoRepository;
    private final ParametroService parametroService;

    public ProcessoAnexoService(ProcessoAnexoRepository repository, ProcessoRepository processoRepository, ParametroService parametroService) {
        this.processoAnexoRepository = repository;
        this.processoRepository = processoRepository;
        this.parametroService = parametroService;
    }

    @Transactional
    public ProcessoAnexo anexarProcesso(Processo processo, Processo processoAnexar, String username) {
        List violations = this.validateProcessoAnexo(processo, processoAnexar);
        EloValidationException.checkViolations((String)"Falha ao anexar processos", (List)violations);
        ProcessoAnexo processoAnexoSalvar = this.processoToAnexo(processo, processoAnexar, username);
        return (ProcessoAnexo)this.processoAnexoRepository.save((Object)processoAnexoSalvar);
    }

    private ProcessoAnexo processoToAnexo(Processo processo, Processo processoAnexar, String usuario) {
        ProcessoAnexoPK processoAnexoPK = new ProcessoAnexoPK(processoAnexar.getId().getTipo(), processoAnexar.getId().getAno(), processoAnexar.getId().getNumero(), processoAnexar.getProximaSequenciaAnexo(), processoAnexar.getId().getEntidade());
        ProcessoAnexo processoAnexo = new ProcessoAnexo();
        processoAnexo.setId(processoAnexoPK);
        processoAnexo.setProcesso(processo);
        processoAnexo.setUsuario(usuario);
        processoAnexo.setUnidade(processoAnexar.getUnidade());
        return processoAnexo;
    }

    public List<EloViolation> validateProcessoAnexo(Processo processoBase, Processo processoAnexar) {
        ArrayList<EloViolation> violations = new ArrayList<EloViolation>();
        if (processoAnexar.isEncaminhado().booleanValue()) {
            violations.add(new EloViolation(this.buildErrorMessage(processoAnexar.getId(), "deve ser recebido antes de ser anexado.")));
        } else if (processoBase.isEncaminhado().booleanValue()) {
            violations.add(new EloViolation(this.buildErrorMessage(processoBase.getId(), "deve ser recebido antes de ser anexado.")));
        } else if (processoBase.isRecebido().booleanValue() && processoAnexar.isArquivado().booleanValue()) {
            violations.add(new EloViolation(this.buildErrorMessage(processoAnexar.getId(), "est\u00e1 arquivado.")));
        }
        if (!processoBase.isMesmoLocal(processoAnexar).booleanValue()) {
            violations.add(new EloViolation(this.buildErrorMessage(processoAnexar.getId(), String.format("n\u00e3o esta no mesmo local do processo de Tipo: %s N\u00famero: %d Ano: %d", processoBase.getId().getTipo().getId(), processoBase.getId().getNumero(), processoBase.getId().getAno()))));
        }
        if (this.isProcessoAnexado(processoAnexar).booleanValue()) {
            violations.add(new EloViolation(this.buildErrorMessage(processoAnexar.getId(), "est\u00e1 anexado em outro processo")));
        }
        if (this.isProcessoComAnexo(processoAnexar).booleanValue()) {
            violations.add(new EloViolation(this.buildErrorMessage(processoAnexar.getId(), "possui outros processos anexos")));
        }
        if (Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.ANEXA_APENAS_PROCESSOS_COM_ASSUNTO_LOCALIZACAO_REQUERENTE_E_CADASTRO_IMOBILIARIO_IGUAL.getCodigo()))) {
            this.validaProcessoAnexoAssuntoRequerenteInfoImovel(violations, processoBase, processoAnexar);
        }
        return violations;
    }

    public void validaProcessoAnexoAssuntoRequerenteInfoImovel(List<EloViolation> violations, Processo processoBase, Processo processoAnexar) {
        if (Boolean.FALSE.equals(processoBase.isMesmoAssunto(processoAnexar))) {
            violations.add(new EloViolation(this.buildErrorMessage(processoAnexar.getId(), String.format("n\u00e3o possui o mesmo assunto do processo de Tipo: %s N\u00famero: %d Ano: %d", processoBase.getId().getTipo().getId(), processoBase.getId().getNumero(), processoBase.getId().getAno()))));
        }
        if (Boolean.FALSE.equals(processoBase.isMesmoRequerente(processoAnexar))) {
            violations.add(new EloViolation(this.buildErrorMessage(processoAnexar.getId(), String.format("n\u00e3o possui o mesmo requerente do processo de Tipo: %s N\u00famero: %d Ano: %d", processoBase.getId().getTipo().getId(), processoBase.getId().getNumero(), processoBase.getId().getAno()))));
        }
        if (Boolean.FALSE.equals(processoBase.isMesmoCadastro(processoAnexar))) {
            violations.add(new EloViolation(this.buildErrorMessage(processoAnexar.getId(), String.format("n\u00e3o possui o mesmo cadastro imobili\u00e1rio do processo de Tipo: %s N\u00famero: %d Ano: %d", processoBase.getId().getTipo().getId(), processoBase.getId().getNumero(), processoBase.getId().getAno()))));
        }
        if (Boolean.FALSE.equals(processoBase.isMesmaZona(processoAnexar))) {
            violations.add(new EloViolation(this.buildErrorMessage(processoAnexar.getId(), String.format("n\u00e3o possui a mesma zona do im\u00f3vel do processo de Tipo: %s N\u00famero: %d Ano: %d", processoBase.getId().getTipo().getId(), processoBase.getId().getNumero(), processoBase.getId().getAno()))));
        }
        if (Boolean.FALSE.equals(processoBase.isMesmaQuadra(processoAnexar))) {
            violations.add(new EloViolation(this.buildErrorMessage(processoAnexar.getId(), String.format("n\u00e3o possui a mesma quadra do im\u00f3vel do processo de Tipo: %s N\u00famero: %d Ano: %d", processoBase.getId().getTipo().getId(), processoBase.getId().getNumero(), processoBase.getId().getAno()))));
        }
        if (Boolean.FALSE.equals(processoBase.isMesmoLote(processoAnexar))) {
            violations.add(new EloViolation(this.buildErrorMessage(processoAnexar.getId(), String.format("n\u00e3o possui o mesmo lote do im\u00f3vel do processo de Tipo: %s N\u00famero: %d Ano: %d", processoBase.getId().getTipo().getId(), processoBase.getId().getNumero(), processoBase.getId().getAno()))));
        }
    }

    @Transactional
    public ResponseEntity<Void> removerProcessoAnexo(Processo processo) {
        Specification spec = ProcessoAnexoSpecificationHelper.byPk((Long)processo.getId().getNumero(), (Long)processo.getId().getAno(), (TipoProcesso)processo.getId().getTipo(), (Entidade)processo.getId().getEntidade());
        ProcessoAnexo processoAnexo = (ProcessoAnexo)this.processoAnexoRepository.findOne(spec).orElseThrow(RestException::notFound);
        this.processoAnexoRepository.delete((Object)processoAnexo);
        return ResponseEntity.ok().build();
    }

    public List<Processo> getProcessosAnexos(Processo processo) {
        Specification spec = ProcessoAnexoSpecificationHelper.byProcesso((Long)processo.getId().getNumero(), (Long)processo.getId().getAno(), (TipoProcesso)processo.getId().getTipo(), (Entidade)processo.getId().getEntidade());
        ArrayList processosAnexos = Lists.newArrayList((Iterable)this.processoAnexoRepository.findAll(spec));
        ArrayList<Processo> processos = new ArrayList<Processo>();
        for (ProcessoAnexo processoAnexo : processosAnexos) {
            Processo processoSalvar = (Processo)this.processoRepository.findOne((Object)ProcessoPK.of((Entidade)processoAnexo.getId().getEntidadeAnexo(), (TipoProcesso)processoAnexo.getId().getTipoAnexo(), (Long)processoAnexo.getId().getNumeroAnexo(), (Long)processoAnexo.getId().getAnoAnexo()));
            processos.add(processoSalvar);
        }
        return processos;
    }

    public Boolean isProcessoAnexado(Processo processo) {
        Specification spec = ProcessoAnexoSpecificationHelper.byPk((Long)processo.getId().getNumero(), (Long)processo.getId().getAno(), (TipoProcesso)processo.getId().getTipo(), (Entidade)processo.getId().getEntidade());
        return this.processoAnexoRepository.count(spec) > 0L;
    }

    public Boolean isProcessoComAnexo(Processo processo) {
        Specification spec = Specification.where((Specification)ProcessoAnexoSpecificationHelper.byProcessoNumero((Long)processo.getId().getNumero())).and(ProcessoAnexoSpecificationHelper.byProcessoEntidade((Entidade)processo.getId().getEntidade())).and(ProcessoAnexoSpecificationHelper.byProcessoAno((Long)processo.getId().getAno()));
        long count = this.processoAnexoRepository.count(spec);
        return count > 0L;
    }

    public ProcessoPK getPkProcessoPai(ProcessoPK pkProcessoFilho) {
        return this.processoAnexoRepository.getProcessoPai(pkProcessoFilho);
    }

    private String buildErrorMessage(ProcessoPK id, String message) {
        return String.format("O processo de Tipo: %d N\u00famero: %d Ano: %d %s", id.getTipo().getId(), id.getNumero(), id.getAno(), message);
    }
}

