/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.client.painel.feign.NotificationFeign;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.lib.painel.dto.DataNotificationDTO;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.protocolo.config.ProtocoloProperties;
import br.com.elotech.protocolo.config.SecurityUtils;
import br.com.elotech.protocolo.converter.LocalDTOConverter;
import br.com.elotech.protocolo.converter.ProcessoAndamentoDTOConverter;
import br.com.elotech.protocolo.converter.UsuarioDTOConverter;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.LocalPK;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoAndamento;
import br.com.elotech.protocolo.domain.ProcessoAndamentoAlteracaoRequerente;
import br.com.elotech.protocolo.domain.ProcessoObservadorExterno;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.TipoAndamento;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.LocalUsuarioComunicacaoDTO;
import br.com.elotech.protocolo.dto.ProcessoAndamentoAutomaticoDTO;
import br.com.elotech.protocolo.dto.ProcessoAndamentoDTO;
import br.com.elotech.protocolo.dto.ProcessoArquivoDTO;
import br.com.elotech.protocolo.enums.AnaliseArquivoEnum;
import br.com.elotech.protocolo.enums.TipoAndamentoEnum;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.mail.senders.impl.ProcessoAndamentoEmailSender;
import br.com.elotech.protocolo.repository.LocalRepository;
import br.com.elotech.protocolo.repository.ProcessoAndamentoRepository;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.repository.UsuarioRepository;
import br.com.elotech.protocolo.service.DataIgnoradaService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.ProcessoAndamentoNotificacaoService;
import br.com.elotech.protocolo.service.ProcessoArquivoService;
import br.com.elotech.protocolo.service.ProcessoIntegracaoService;
import br.com.elotech.protocolo.service.TipoAndamentoService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessoAndamentoService
extends CrudService<ProcessoAndamento, Long> {
    private final ProcessoAndamentoRepository repository;
    private final ProcessoIntegracaoService processoIntegracaoService;
    private final ProcessoArquivoService processoArquivoService;
    private final NotificationFeign notificationFeign;
    private final UsuarioService usuarioService;
    private final ProcessoRepository processoRepository;
    private final TipoAndamentoService tipoAndamentoService;
    private final ParametroService parametroService;
    private final DataIgnoradaService dataIgnoradaService;
    private final MailService mailService;
    private final ProtocoloProperties emailProperties;
    private final UsuarioRepository usuarioRepository;
    private final LocalRepository localRepository;
    private final ProcessoAndamentoEmailSender processoAndamentoEmailSender;
    private final ProcessoAndamentoNotificacaoService processoAndamentoNotificacaoService;

    @Transactional
    public ProcessoAndamento save(Processo processoSalvo, ProcessoAndamento andamento) {
        ProcessoAndamento savedAndamento;
        Processo processo = (Processo)this.processoRepository.findById((Object)processoSalvo.getId()).orElseThrow(() -> new RegistroNaoEncontradoException(Processo.class));
        processo.setUltimaAtualizacao(LocalDateTime.now());
        andamento.setProcesso(processo);
        andamento.setDataHora(LocalDateTime.now());
        if (Objects.nonNull(andamento.getSituacaoProcessoNew()) && TipoAndamentoEnum.ALTERASITUACAO.equals((Object)andamento.getTipoAndamento().getTipo())) {
            processo.setSituacao(andamento.getSituacaoProcessoNew());
        }
        if (Objects.nonNull(andamento.getTipoAndamento()) && TipoAndamentoEnum.ALTERASIGREQUERENTE.equals((Object)andamento.getTipoAndamento().getTipo())) {
            processo.getProcessoMp().setRequerenteSigiloso(andamento.getRequerenteSigiloso());
        }
        if (Objects.nonNull(andamento.getTipoAndamento()) && TipoAndamentoEnum.ALTERAREQUERENTE.equals((Object)andamento.getTipoAndamento().getTipo())) {
            this.validateAlteracaoRequerente(processo, andamento.getAlteracaoRequerente());
            andamento.getAlteracaoRequerente().setRequerenteOld(processo.getPessoa());
        }
        processo.getUltimoTramite().ifPresent(tramite -> andamento.setTramite(tramite.getSequencia()));
        if (Objects.nonNull(andamento.getLocal())) {
            andamento.getLocal().getId().setEntidade(RequestHeaderHelper.getEntidadeContextHolder());
        }
        if (Boolean.TRUE.equals(andamento.getFinalizado())) {
            this.finalizarAndamento(andamento);
        }
        if (Boolean.TRUE.equals((savedAndamento = this.saveAndamento(andamento)).getFinalizado()) && Boolean.TRUE.equals(savedAndamento.getSolicitacaoRequerente())) {
            this.processoAndamentoEmailSender.enviarEmailSolicitacaoRemetente(andamento);
        }
        return savedAndamento;
    }

    private ProcessoAndamento saveAndamento(ProcessoAndamento andamento) {
        this.processoRepository.saveAndFlush((Object)andamento.getProcesso());
        ProcessoAndamento andamentoSaved = (ProcessoAndamento)this.repository.saveAndFlush((Object)andamento);
        this.processoIntegracaoService.salvarProcessoIntegracao(andamentoSaved.getProcesso());
        return andamentoSaved;
    }

    @Transactional
    public ProcessoAndamento responder(Long id, String resposta, List<ProcessoArquivoDTO> arquivos) {
        ProcessoAndamento andamento = (ProcessoAndamento)this.repository.findById((Object)id).orElseThrow(EntityNotFoundException::new);
        andamento.setRespostaRequerente(resposta);
        andamento.setDataHoraResposta(LocalDateTime.now());
        if (Objects.nonNull(arquivos)) {
            arquivos.forEach(arquivo -> this.processoArquivoService.addArquivo(andamento.getProcesso(), arquivo));
        }
        this.enviarNotificacao(andamento);
        return this.saveAndamento(andamento);
    }

    private void enviarNotificacao(ProcessoAndamento andamento) {
        DataNotificationDTO dataNotificationDTO = new DataNotificationDTO();
        dataNotificationDTO.setUsername(andamento.getUsuario());
        dataNotificationDTO.setType("Notifica\u00e7\u00e3o");
        dataNotificationDTO.setModulo(Modulo.OXY_PROCESSOS);
        dataNotificationDTO.setStatus(NotificationStatus.COMPLETED);
        dataNotificationDTO.setMessage("Atualiza\u00e7\u00e3o de processo.");
        String messageDetail = String.format("Processo n\u00b0 %s/%s", andamento.getProcesso().getId().getNumero(), andamento.getProcesso().getId().getAno());
        dataNotificationDTO.setMessageDetail(messageDetail);
        dataNotificationDTO.setLink(String.format("/protocolo/processos-novo/view/%s#andamentos", andamento.getProcesso().getId().getKey()));
        this.notificationFeign.publishMessage(dataNotificationDTO);
    }

    @Transactional
    public ProcessoAndamento update(ProcessoAndamento andamento, ProcessoAndamento atualizado) {
        andamento.setAlteracaoRequerente(atualizado.getAlteracaoRequerente());
        andamento.setRequerenteSigiloso(atualizado.getRequerenteSigiloso());
        if (Boolean.FALSE.equals(andamento.getFinalizado()) && Boolean.TRUE.equals(atualizado.getFinalizado())) {
            this.finalizarAndamento(andamento);
            if (Boolean.TRUE.equals(atualizado.getSolicitacaoRequerente())) {
                this.processoAndamentoEmailSender.enviarEmailSolicitacaoRemetente(andamento);
            }
        }
        andamento.setNumeroAndamento(atualizado.getNumeroAndamento());
        andamento.setDescricao(atualizado.getDescricao());
        andamento.setSolicitacaoRequerente(atualizado.getSolicitacaoRequerente());
        andamento.setDataHora(LocalDateTime.now());
        andamento.setDataTermino(atualizado.getDataTermino());
        andamento.setDataInicio(atualizado.getDataInicio());
        andamento.setFinalizado(atualizado.getFinalizado());
        andamento.setTipoAndamento(atualizado.getTipoAndamento());
        andamento.setDataFinalizacao(atualizado.getDataFinalizacao());
        andamento.setDiasSuspensao(atualizado.getDiasSuspensao());
        return this.saveAndamento(andamento);
    }

    public Page<ProcessoAndamentoDTO> getAllDTO(String search, Pageable pageable, String usuarioLogado) {
        String searchProcessed = this.processSearch(search, usuarioLogado);
        List list = this.findByRsql(searchProcessed, pageable).stream().map(p -> new ProcessoAndamentoDTOConverter().to(p, Boolean.valueOf(true))).collect(Collectors.toList());
        return new PageImpl(list, pageable, this.count(searchProcessed).longValue());
    }

    public Boolean existsByObservadorExtId(UUID observadorExtId) {
        return this.repository.existsByObservadorExtId(observadorExtId);
    }

    protected void finalizarAndamento(ProcessoAndamento andamento) {
        Processo processo = andamento.getProcesso();
        if (Objects.nonNull(andamento.getTipoAndamento().getTipoAndamento())) {
            this.createAndamentoAutomatico(ProcessoAndamentoAutomaticoDTO.builder().processo(andamento.getProcesso()).tipoAndamento(andamento.getTipoAndamento().getTipoAndamento()).build());
        }
        if (TipoAndamentoEnum.PREVISAOCONCLUSAO.equals((Object)andamento.getTipoAndamento().getTipo())) {
            processo.setPrevisaoConclusao(andamento.getDataTermino());
        }
        if (TipoAndamentoEnum.SUSPENSAO.equals((Object)andamento.getTipoAndamento().getTipo())) {
            LocalDate dataConclusao = Optional.ofNullable(processo.getPrevisaoConclusao()).orElse(LocalDate.now());
            LocalDate novaDataConclusao = this.dataIgnoradaService.sugereData(andamento.getTipoAndamento().getId(), dataConclusao.plusDays(andamento.getDiasSuspensao()));
            processo.setPrevisaoConclusao(novaDataConclusao);
        }
        if (TipoAndamentoEnum.ALTERACAOCATEGORIA.equals((Object)andamento.getTipoAndamento().getTipo())) {
            processo.setAssunto(andamento.getAssuntoNew());
        }
        if (TipoAndamentoEnum.DISPENSAPRORROGACAO.equals((Object)andamento.getTipoAndamento().getTipo())) {
            processo.setPrevisaoConclusao(null);
        }
        if (TipoAndamentoEnum.DEFINICAOSIGILOSO.equals((Object)andamento.getTipoAndamento().getTipo())) {
            processo.setSigiloso(andamento.getDefinirSigiloso());
        }
        if (TipoAndamentoEnum.BLOQUEIOANEXOEXTERNO.equals((Object)andamento.getTipoAndamento().getTipo())) {
            processo.setBloqueioAnexoExterno(andamento.getBloqueioAnexoExterno());
        }
        if (TipoAndamentoEnum.TAD.equals((Object)andamento.getTipoAndamento().getTipo())) {
            Optional.ofNullable(processo.getProcessoMp()).ifPresent(processoMp -> processoMp.setTad(andamento.getTad()));
        }
        if (TipoAndamentoEnum.DATAACORDO.equals((Object)andamento.getTipoAndamento().getTipo())) {
            Optional.ofNullable(processo.getProcessoMp()).ifPresent(processoMp -> processoMp.setDataAcordo(andamento.getDataAcordo()));
        }
        if (TipoAndamentoEnum.PRAZO.equals((Object)andamento.getTipoAndamento().getTipo())) {
            Optional.ofNullable(processo.getProcessoMp()).ifPresent(processoMp -> processoMp.setPrazo(andamento.getPrazo()));
        }
        if (TipoAndamentoEnum.ALTERAREQUERENTE.equals((Object)andamento.getTipoAndamento().getTipo())) {
            this.validateAlteracaoRequerente(processo, andamento.getAlteracaoRequerente());
            processo.setPessoa(andamento.getAlteracaoRequerente().getRequerenteNew());
        }
        andamento.setProcesso(processo);
    }

    public void finalizarAndamentoByObservadorExtId(String observadorExtId) {
        UUID observadorExtUUID = UUID.fromString(observadorExtId);
        ProcessoAndamento processoAndamento = this.repository.findFirstByObservadorExtId(observadorExtUUID);
        if (Objects.nonNull(processoAndamento) && Boolean.FALSE.equals(processoAndamento.getFinalizado())) {
            boolean isLastObservador = this.isLastObservador(observadorExtUUID, processoAndamento);
            processoAndamento.setDataFinalizacao(processoAndamento.getDataHora());
            processoAndamento.setFinalizado(Boolean.TRUE);
            this.repository.saveAndFlush((Object)processoAndamento);
            if (Objects.nonNull(processoAndamento.getTipoAndamento().getTipoAndamento()) && isLastObservador) {
                this.createAndamentoAutomatico(ProcessoAndamentoAutomaticoDTO.builder().processo(processoAndamento.getProcesso()).tipoAndamento(processoAndamento.getTipoAndamento().getTipoAndamento()).descricao("Andamento gerado automaticamente pela visualiza\u00e7\u00e3o externa do processo via chave").build());
            }
        }
    }

    public Long createAndamentoAnexoExterno(Processo processo, String fileName) {
        TipoAndamento tipoAndamento = this.tipoAndamentoService.findByTipoAnexoExterno();
        if (tipoAndamento != null) {
            ProcessoAndamento processoAndamento = this.createAndamentoAutomatico(ProcessoAndamentoAutomaticoDTO.builder().processo(processo).tipoAndamento(tipoAndamento).descricao(String.format("Andamento gerado automaticamente pela inclus\u00e3o do documento %s via consulta externa", fileName)).finalizado(Boolean.TRUE).build());
            this.processoAndamentoNotificacaoService.enviarNotificacaoAnexoExterno(processoAndamento);
            return processoAndamento.getId();
        }
        return null;
    }

    public ProcessoAndamento createAndamentoAutomatico(ProcessoAndamentoAutomaticoDTO dto) {
        String username = Optional.ofNullable(SecurityUtils.getUsername()).orElse("USER_EXTERNO");
        Integer prazoBase = Optional.ofNullable(dto.getTipoAndamento().getPrazoBase()).orElse(0);
        LocalDate dataTermino = this.dataIgnoradaService.sugereData(dto.getTipoAndamento().getId(), LocalDate.now().plusDays(prazoBase.intValue()));
        Usuario usuario = this.usuarioService.findUsuarioByName(username);
        ProcessoAndamento processoAndamento = new ProcessoAndamento();
        processoAndamento.setUsuario(usuario.getId());
        processoAndamento.setUsuarioNome(usuario.getNome());
        processoAndamento.setDescricao(dto.getDescricao());
        processoAndamento.setModulo(Modulo.OXY_PROCESSOS);
        processoAndamento.setSolicitacaoRequerente(Boolean.FALSE);
        processoAndamento.setDataInicio(LocalDate.now());
        processoAndamento.setDataTermino(dataTermino);
        processoAndamento.setTipoAndamento(dto.getTipoAndamento());
        processoAndamento.setObservadorExtId(dto.getObservadorExtId());
        processoAndamento.setFinalizado(dto.getFinalizado());
        processoAndamento.setDataFinalizacao(Boolean.TRUE.equals(dto.getFinalizado()) ? LocalDateTime.now() : null);
        if (Objects.nonNull(dto.getUsuarioResponsavel())) {
            Usuario usuarioResponsavel = (Usuario)this.usuarioRepository.findOne((Object)dto.getUsuarioResponsavel().getId());
            processoAndamento.setUsuarioResponsavel(usuarioResponsavel);
        }
        if (Objects.nonNull(dto.getLocal())) {
            Local local = new Local(LocalPK.of((Entidade)RequestHeaderHelper.getEntidadeContextHolder(), (Long)dto.getLocal().getId()));
            processoAndamento.setLocal(local);
        }
        return this.save(dto.getProcesso(), processoAndamento);
    }

    public Long getQuantidadeAnexosExternos(String usuarioLogado) {
        Long paramDias = Optional.ofNullable(this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_ANEXO_EXTERNO.getCodigo())).orElse(5L);
        boolean paramApenasNaoAnalisados = Boolean.TRUE.equals(this.parametroService.getParamValueAsBoolean(ParametroEnum.NOVOS_ANEXOS_EXTERNO_IGNORA_ANALISADOS.getCodigo()));
        LocalDateTime dataHora = LocalDate.now().atStartOfDay().minusDays(paramDias);
        String filterAnalisados = paramApenasNaoAnalisados ? " and arquivos.analise==".concat(AnaliseArquivoEnum.NAO_ANALISADO.getValue()) : "";
        return this.count(this.searchAnexoExterno(usuarioLogado).concat(filterAnalisados).concat(String.format(" and dataHora>=%s", dataHora.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME))));
    }

    public Long getNumeroRecomendado(Long tipoAndamentoId, Long ano) {
        return this.repository.getNumeroRecomendado(tipoAndamentoId, ano);
    }

    protected boolean isLastObservador(UUID observadorExtUUID, ProcessoAndamento processoAndamento) {
        List processosAbertos = processoAndamento.getProcesso().getAndamentos().stream().filter(andamento -> {
            Optional<ProcessoObservadorExterno> observador = andamento.getProcesso().getObservadoresExternos().stream().filter(obs -> obs.getId().equals(andamento.getObservadorExtId())).findFirst();
            if (observador.isEmpty()) {
                return false;
            }
            Boolean isObrigaVisualizacao = Boolean.TRUE.equals(observador.get().getObrigaVisualizacao());
            Boolean isNotFinalizado = Boolean.FALSE.equals(andamento.getFinalizado());
            return isObrigaVisualizacao != false && isNotFinalizado != false;
        }).collect(Collectors.toList());
        Boolean apenasUmProcessoAberto = processosAbertos.size() == 1;
        Boolean isObservadorCorrente = processosAbertos.stream().anyMatch(andamento -> andamento.getObservadorExtId().equals(observadorExtUUID));
        return apenasUmProcessoAberto != false && isObservadorCorrente != false;
    }

    public void createAndamentoComunicacao(Processo processo, LocalUsuarioComunicacaoDTO locaisUsuariosComunicacao) {
        Entidade entidadeLogada = RequestHeaderHelper.getEntidadeContextHolder();
        TipoAndamento tipoAndamento = this.tipoAndamentoService.findByTipoComunicacaoInterna();
        if (Boolean.TRUE.equals(locaisUsuariosComunicacao.getMarcarTodosLocais())) {
            List locais = this.localRepository.findById_Entidade(entidadeLogada);
            locaisUsuariosComunicacao.getLocais().addAll(locais.stream().map(local -> new LocalDTOConverter().to(local)).collect(Collectors.toList()));
        }
        if (Boolean.TRUE.equals(locaisUsuariosComunicacao.getMarcarTodosUsuarios())) {
            List usuarios = this.usuarioRepository.findByEntidades_Id_Entidade(entidadeLogada);
            locaisUsuariosComunicacao.getUsuarios().addAll(usuarios.stream().map(usuario -> new UsuarioDTOConverter().to(usuario)).collect(Collectors.toList()));
        }
        if (Objects.nonNull(tipoAndamento)) {
            locaisUsuariosComunicacao.getLocais().forEach(local -> this.createAndamentoAutomatico(ProcessoAndamentoAutomaticoDTO.builder().processo(processo).tipoAndamento(tipoAndamento).descricao("Comunica\u00e7\u00e3o Interna").finalizado(Boolean.FALSE).local(local).build()));
            locaisUsuariosComunicacao.getUsuarios().forEach(usuarioResponsavel -> {
                ProcessoAndamento processoAndamento = this.createAndamentoAutomatico(ProcessoAndamentoAutomaticoDTO.builder().processo(processo).tipoAndamento(tipoAndamento).descricao("Comunica\u00e7\u00e3o Interna").finalizado(Boolean.FALSE).usuarioResponsavel(usuarioResponsavel).build());
                try {
                    this.sendEmailUsuarioResponsavel(processoAndamento);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public void aceite(Long id, String resposta) {
        ProcessoAndamento andamento = (ProcessoAndamento)this.repository.findOne((Object)id);
        andamento.setResposta(resposta);
        andamento.setFinalizado(Boolean.TRUE);
        andamento.setDataHoraResposta(LocalDateTime.now());
        andamento.setDataFinalizacao(andamento.getDataHora());
        this.save(andamento.getProcesso(), andamento);
    }

    public void sendEmailUsuarioResponsavel(ProcessoAndamento processoAndamento) throws ExecutionException, InterruptedException, TimeoutException {
        if (Objects.nonNull(processoAndamento.getUsuarioResponsavel()) && Objects.nonNull(processoAndamento.getUsuarioResponsavel().getEmail())) {
            String remetente = this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_REMETENTE_PADRAO.getCodigo());
            String email = processoAndamento.getUsuarioResponsavel().getEmail();
            Processo processo = processoAndamento.getProcesso();
            ProcessoPK processoPK = processo.getId();
            String subject = "Comunica\u00e7\u00e3o Interna - " + processoPK.getTipo().getDescricao() + " - " + processoPK.getNumero() + '/' + processoPK.getAno();
            String content = "<b>Processo: </b>" + processoPK.getTipo().getDescricao() + " - " + processoPK.getNumero() + '/' + processoPK.getAno();
            MailParams mailParams = MailParams.builder().encoding(this.emailProperties.getMail().getEncoding()).to(email).from(remetente).subject(subject).html(Boolean.TRUE.booleanValue()).multipart(Boolean.FALSE.booleanValue()).content(content).build();
            this.mailService.sendEmail(mailParams).get(1L, TimeUnit.MINUTES);
        }
    }

    public Long getNovosComunicados(String usuarioLogado) {
        return this.count(this.searchLiberadosParaAssinar(usuarioLogado));
    }

    protected String processSearch(String search, String usuarioLogado) {
        String[] filters = search.split(" and ");
        ArrayList<String> treatedFilter = new ArrayList<String>();
        for (String filter : filters) {
            if (filter.contains("apenasLiberadosParaAceite")) {
                if (!filter.contains("apenasLiberadosParaAceite==true")) continue;
                treatedFilter.add(this.searchLiberadosParaAssinar(usuarioLogado));
                continue;
            }
            if (filter.contains("ANEXOEXTERNO")) {
                treatedFilter.add(this.searchAnexoExterno(usuarioLogado));
                continue;
            }
            treatedFilter.add(filter);
        }
        return String.join((CharSequence)" and ", treatedFilter);
    }

    protected String searchLiberadosParaAssinar(String usuarioLogado) {
        List locaisComPermissao = this.usuarioService.listarLocaisUsuario(new Usuario(usuarioLogado));
        String locaisFormatados = locaisComPermissao.stream().map(usuariolocal -> usuariolocal.getId().getLocal().getId().getId().toString()).collect(Collectors.joining(","));
        return String.format("(tipoAndamento.tipo==%s and finalizado==false and usuarioResponsavel.id==%s)%s", TipoAndamentoEnum.COMUNICACAOINTERNA, usuarioLogado, String.format(StringUtils.isNotEmpty((CharSequence)locaisFormatados) ? " or (tipoAndamento.tipo==%s and finalizado==false and local.id.id=in=(%s))" : "", TipoAndamentoEnum.BLOQUEIOANEXOEXTERNO, locaisFormatados));
    }

    protected String searchAnexoExterno(String usuarioLogado) {
        List locaisComPermissao;
        String locaisFormatados;
        StringJoiner filtroUsuario = new StringJoiner(" or ");
        filtroUsuario.add(String.format("usuarioResponsavel.id==%s", usuarioLogado));
        Usuario usuario = this.usuarioService.findUsuarioByName(usuarioLogado);
        String entidades = usuario.getEntidades().stream().filter(ue -> Boolean.TRUE.equals(ue.getAlteraTodosProc())).map(ue -> ue.getId().getEntidade().getId().toString()).collect(Collectors.joining(","));
        if (StringUtils.isNotBlank((CharSequence)entidades)) {
            filtroUsuario.add(String.format("processo.id.entidade.id=in=(%s)", entidades));
        }
        if (StringUtils.isNotBlank((CharSequence)(locaisFormatados = (locaisComPermissao = this.usuarioService.listarLocaisUsuario(new Usuario(usuarioLogado))).stream().map(usuariolocal -> usuariolocal.getId().getLocal().getId().getId().toString()).collect(Collectors.joining(","))))) {
            filtroUsuario.add(String.format("processo.localAtual.id.id=in=(%s)", locaisFormatados));
        }
        return String.format("tipoAndamento.tipo==%s and (%s)", TipoAndamentoEnum.ANEXOEXTERNO.name(), filtroUsuario);
    }

    private void validateAlteracaoRequerente(Processo processo, ProcessoAndamentoAlteracaoRequerente processoAndamentoAlteracaoRequerente) {
        if (Objects.isNull(processoAndamentoAlteracaoRequerente) || Objects.isNull(processoAndamentoAlteracaoRequerente.getRequerenteNew())) {
            throw new EloValidationException("Requerente n\u00e3o pode ser vazio!");
        }
        if (Objects.nonNull(processo.getIdProcessoTaxa())) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel alterar o requerente de um processo com boleto/debito gerado!");
        }
    }

    @Generated
    public ProcessoAndamentoService(ProcessoAndamentoRepository repository, ProcessoIntegracaoService processoIntegracaoService, ProcessoArquivoService processoArquivoService, NotificationFeign notificationFeign, UsuarioService usuarioService, ProcessoRepository processoRepository, TipoAndamentoService tipoAndamentoService, ParametroService parametroService, DataIgnoradaService dataIgnoradaService, MailService mailService, ProtocoloProperties emailProperties, UsuarioRepository usuarioRepository, LocalRepository localRepository, ProcessoAndamentoEmailSender processoAndamentoEmailSender, ProcessoAndamentoNotificacaoService processoAndamentoNotificacaoService) {
        this.repository = repository;
        this.processoIntegracaoService = processoIntegracaoService;
        this.processoArquivoService = processoArquivoService;
        this.notificationFeign = notificationFeign;
        this.usuarioService = usuarioService;
        this.processoRepository = processoRepository;
        this.tipoAndamentoService = tipoAndamentoService;
        this.parametroService = parametroService;
        this.dataIgnoradaService = dataIgnoradaService;
        this.mailService = mailService;
        this.emailProperties = emailProperties;
        this.usuarioRepository = usuarioRepository;
        this.localRepository = localRepository;
        this.processoAndamentoEmailSender = processoAndamentoEmailSender;
        this.processoAndamentoNotificacaoService = processoAndamentoNotificacaoService;
    }
}

