/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.client.painel.feign.NotificationFeign;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.lib.painel.dto.DataNotificationDTO;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.ProcessoAndamento;
import br.com.elotech.protocolo.repository.UsuarioLocalRepository;
import br.com.elotech.protocolo.service.ParametroService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ProcessoAndamentoNotificacaoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoAndamentoNotificacaoService.class);
    private final ParametroService parametroService;
    private final UsuarioLocalRepository usuarioLocalRepository;
    private final NotificationFeign notificationFeign;

    public void enviarNotificacaoAnexoExterno(ProcessoAndamento processoAndamento) {
        Boolean notificaAnexoExterno = this.parametroService.getParamValueAsBoolean(ParametroEnum.NOTIFICA_ANEXO_EXTERNO.getCodigo());
        if (Boolean.FALSE.equals(notificaAnexoExterno)) {
            return;
        }
        List usuariosLocais = this.usuarioLocalRepository.findByIdLocal(processoAndamento.getProcesso().getLocalAtual());
        Long andamentoId = processoAndamento.getId();
        Long processoNumero = processoAndamento.getProcesso().getId().getNumero();
        Long processoAno = processoAndamento.getProcesso().getId().getAno();
        usuariosLocais.forEach(usuarioLocal -> {
            DataNotificationDTO dto = new DataNotificationDTO();
            dto.setModulo(Modulo.OXY_PROCESSOS);
            dto.setStatus(NotificationStatus.COMPLETED);
            dto.setUsername(usuarioLocal.getId().getUsuario().getId());
            dto.setMessage("Anexo Externo");
            dto.setMessageDetail(String.format("Novo anexo externo inserido no Processo %s/%s", processoNumero, processoAno));
            dto.setLink(String.format("/protocolo/controle-andamentos?filters==id_Igual=%s", andamentoId));
            try {
                this.notificationFeign.publishMessage(dto);
            }
            catch (Exception e) {
                log.error("Falha ao publicar mensagem ", (Throwable)e);
            }
        });
    }

    @Generated
    public ProcessoAndamentoNotificacaoService(ParametroService parametroService, UsuarioLocalRepository usuarioLocalRepository, NotificationFeign notificationFeign) {
        this.parametroService = parametroService;
        this.usuarioLocalRepository = usuarioLocalRepository;
        this.notificationFeign = notificationFeign;
    }
}

