/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.dto.ConfigRestricao;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.service.ProcessoService;
import br.com.elotech.protocolo.service.RestricaoService;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class ProcessoAgrupadaoValidacaoService {
    private final ProcessoService processoService;
    private final RestricaoService restricaoService;

    public ProcessoAgrupadaoValidacaoService(ProcessoService processoService, RestricaoService restricaoService) {
        this.processoService = processoService;
        this.restricaoService = restricaoService;
    }

    public void validarSigiloProcesso(Processo processo, ConfigRestricao configRestricao) {
        if (!this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo).booleanValue()) {
            throw new RestException(HttpStatus.FORBIDDEN, "Processo bloqueado, o usu\u00e1rio n\u00e3o possui acesso aos locais aos quais o processo teve tramita\u00e7\u00e3o ou esta classificado como sigiloso.");
        }
    }

    public void validarVinculoProcessoPai(Processo processo) {
        if (this.processoService.getProcessoPai(processo.getId()) != null) {
            throw new RestException(HttpStatus.BAD_REQUEST, "O processo selecionado est\u00e1 anexado a outro processo. Selecione o processo pai.");
        }
    }

    public void validarControleTramitacao(List<Processo> processos, Funcao funcao) {
        if (processos.size() > 1 && Processo.possuiProcessoComControleDeTramitacao(processos).booleanValue() && Funcao.ENCAMINHADO.equals((Object)funcao)) {
            throw new RestException(HttpStatus.BAD_REQUEST, "S\u00f3 \u00e9 poss\u00edvel tramitar um processo com controle de tramita\u00e7\u00e3o por vez!");
        }
    }

    public void validarPagamentoTributos(Processo processo) {
        if (processo.getIdProcessoTaxa() != null || processo.getPossuiTaxa().booleanValue()) {
            this.processoService.verificarStatusPagamento(processo);
        }
    }
}

