/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.json.update.JsonUpdatePartial;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.protocolo.config.PessoaClientUnico;
import br.com.elotech.protocolo.domain.EnderecoPessoa;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.ProcessoInteressadoDTO;
import br.com.elotech.protocolo.exception.UnicoClientNaoEncontradoException;
import br.com.elotech.protocolo.repository.PessoaRepository;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.PessoaService;
import br.com.elotech.unico.client.dto.ContatoDTO;
import br.com.elotech.unico.client.dto.PessoaContatoDTO;
import br.com.elotech.unico.client.dto.PessoaDTO;
import br.com.elotech.unico.client.dto.PessoaExistsDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"onpremise", "cloud"})
public class PessoaUnicoService
extends CrudService<Pessoa, Long>
implements PessoaService {
    private final Optional<PessoaClientUnico> pessoaClient;
    private final ParametroService parametroService;
    private final EntidadeService entidadeService;
    private final ObjectMapper objectMapper;

    public PessoaUnicoService(Optional<PessoaClientUnico> pessoaClient, ParametroService parametroService, EntidadeService entidadeService, ObjectMapper objectMapper) {
        this.pessoaClient = pessoaClient;
        this.parametroService = parametroService;
        this.entidadeService = entidadeService;
        this.objectMapper = objectMapper;
    }

    public PessoaRepository getPessoas() {
        return (PessoaRepository)this.getCrudRepository();
    }

    protected void beforeSave(Pessoa entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        for (EnderecoPessoa endereco : entity.getEnderecos()) {
            if (entity.equals((Object)endereco.getPk().getPessoa())) continue;
            endereco.getPk().setPessoa(entity);
        }
        List enderecos = entity.getEnderecos();
        if (entity.isNew() && !enderecos.isEmpty()) {
            entity.setSequenciaEndereco(((EnderecoPessoa)enderecos.get(0)).getPk().getCodigo());
        }
    }

    public List<Pessoa> getPessoaDuplicateByCpfCnpj(String cnpjCpf) {
        return this.getPessoas().findAllBycnpjCpf(cnpjCpf);
    }

    public List<Pessoa> getPessoaByCnpjCpfOrderById(String cnpjCpf) {
        EloPage pessoasUnico;
        List pessoasProtocolo = this.getPessoas().findAllByCnpjCpfOrderById(cnpjCpf);
        if (pessoasProtocolo.isEmpty() && !(pessoasUnico = this.getPessoaClientUnico().exists(cnpjCpf)).getContent().isEmpty()) {
            PessoaDTO pessoaDTO = this.getPessoaClientUnico().ativaProtocolo(((PessoaExistsDTO)pessoasUnico.getContent().get(0)).getId());
            return List.of((Pessoa)this.getPessoas().findById((Object)pessoaDTO.getId()).orElseThrow());
        }
        return pessoasProtocolo;
    }

    private List<Pessoa> getPessoaAtivaUnico(String cnpjCpf) {
        EloPage pessoasUnico = this.getPessoaClientUnico().exists(cnpjCpf);
        for (PessoaExistsDTO pessoaExistsDTO : pessoasUnico.getContent()) {
            PessoaDTO pessoaDTO = this.getPessoaClientUnico().getPessoaById(pessoaExistsDTO.getId());
            if (pessoaDTO.getInativo().booleanValue()) continue;
            pessoaDTO = this.getPessoaClientUnico().ativaProtocolo(pessoaDTO.getId());
            Pessoa pessoa = (Pessoa)this.getPessoas().findById((Object)pessoaDTO.getId()).orElseThrow();
            return List.of(pessoa);
        }
        return new ArrayList<Pessoa>();
    }

    public List<Pessoa> findAllByAtivoIsTrueAndCnpjCpfOrderById(String cnpjCpf) {
        List pessoasProtocolo = this.getPessoas().findAllByAtivoIsTrueAndCnpjCpfOrderById(cnpjCpf);
        if (!pessoasProtocolo.isEmpty()) {
            return pessoasProtocolo;
        }
        return this.getPessoaAtivaUnico(cnpjCpf);
    }

    public br.com.elotech.protocolo.dto.PessoaDTO savePessoa(br.com.elotech.protocolo.dto.PessoaDTO pessoaDTO) {
        Entidade entidade = (Entidade)this.entidadeService.findOne((Serializable)this.parametroService.getParamLongEntidadeProcessoExterno());
        boolean isIntegradoTributario = this.parametroService.getParamValueAsBoolean(ParametroEnum.INTEGRADO_TRIBUTACAO.getCodigo(), entidade.getId(), Long.valueOf(LocalDate.now().getYear()));
        List pessoas = this.getPessoaByCnpjCpfOrderById(pessoaDTO.getCnpjCpf());
        if (!pessoas.isEmpty()) {
            pessoaDTO.setId(((Pessoa)pessoas.get(0)).getId());
        }
        if (pessoaDTO.getId() == null) {
            PessoaDTO savedPessoa = this.createPessoaUnico(pessoaDTO, isIntegradoTributario);
            pessoaDTO.setId(savedPessoa.getCodigoProtocolo());
            pessoaDTO.setIdUnico(savedPessoa.getId());
        } else {
            this.updatePessoaUnico(pessoaDTO, isIntegradoTributario);
        }
        return pessoaDTO;
    }

    public br.com.elotech.protocolo.dto.PessoaDTO savePessoaProcessoExterno(ProcessoDTO processoDTO) {
        return this.savePessoa(processoDTO.getPessoa());
    }

    public br.com.elotech.protocolo.dto.PessoaDTO savePessoaProcessoInteressadoExterno(ProcessoInteressadoDTO interessadoDTO) {
        return this.savePessoa(interessadoDTO.getPessoa());
    }

    private PessoaClientUnico getPessoaClientUnico() {
        return (PessoaClientUnico)this.pessoaClient.orElseThrow(() -> new UnicoClientNaoEncontradoException("Falha ao sincronizar client do unico, inst\u00e2ncia est\u00e1 vazia."));
    }

    private void createContatoUnico(br.com.elotech.protocolo.dto.PessoaDTO pessoaDTO, PessoaDTO pessoaUnico) {
        String value;
        ContatoDTO contatoDTOUnico = new ContatoDTO();
        contatoDTOUnico.setNome(pessoaDTO.getNome());
        contatoDTOUnico.setEmail(pessoaDTO.getEmail());
        contatoDTOUnico.setTelefoneCelular(pessoaDTO.getCelular());
        PessoaContatoDTO pessoaContatoDtoUnico = new PessoaContatoDTO();
        pessoaContatoDtoUnico.setContato(contatoDTOUnico);
        pessoaContatoDtoUnico.setPrincipal(Boolean.TRUE);
        try {
            value = this.objectMapper.writeValueAsString((Object)pessoaContatoDtoUnico);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new EloValidationException("Erro ao converter PessoaContatoDTO para json");
        }
        List<JsonUpdatePartial> updates = Collections.singletonList(JsonUpdatePartial.add((String)"/contatos", (String)value));
        this.getPessoaClientUnico().patchPessoa(pessoaUnico.getId(), updates);
    }

    private void updateContatoUnico(br.com.elotech.protocolo.dto.PessoaDTO pessoaDTO, PessoaDTO pessoaUnico, PessoaContatoDTO contatoDTO) {
        String path = String.format("/contatos/%d/contato", contatoDTO.getId());
        List<JsonUpdatePartial> updates = Arrays.asList(JsonUpdatePartial.replace((String)(path + "/email"), (String)pessoaDTO.getEmail()), JsonUpdatePartial.replace((String)(path + "/telefoneCelular"), (String)pessoaDTO.getCelular()));
        this.getPessoaClientUnico().patchPessoa(pessoaUnico.getId(), updates);
    }

    private PessoaDTO createPessoaUnico(br.com.elotech.protocolo.dto.PessoaDTO pessoaDTO, boolean isIntegradoTributario) {
        ContatoDTO contatoDTOUnico = new ContatoDTO();
        contatoDTOUnico.setNome(pessoaDTO.getNome());
        contatoDTOUnico.setEmail(pessoaDTO.getEmail());
        contatoDTOUnico.setTelefoneCelular(pessoaDTO.getCelular());
        PessoaContatoDTO pessoaContatoDtoUnico = new PessoaContatoDTO();
        pessoaContatoDtoUnico.setContato(contatoDTOUnico);
        pessoaContatoDtoUnico.setPrincipal(Boolean.TRUE);
        PessoaDTO pessoaDtoUnico = new PessoaDTO();
        pessoaDtoUnico.setCnpjCpf(pessoaDTO.getCnpjCpf());
        pessoaDTO.definirTipoPessoa();
        pessoaDtoUnico.setTipoPessoa(pessoaDTO.getTipoPessoa().getValue());
        pessoaDtoUnico.setNome(pessoaDTO.getNome());
        pessoaDtoUnico.setNomeFantasia(pessoaDTO.getNome());
        pessoaDtoUnico.getContatos().add(pessoaContatoDtoUnico);
        pessoaDtoUnico.setProtocolo(Boolean.valueOf(true));
        pessoaDtoUnico.setDataNascimento(pessoaDTO.getDataNascimento());
        if (isIntegradoTributario) {
            pessoaDtoUnico.setContribuinte(Boolean.valueOf(true));
        }
        return this.getPessoaClientUnico().savePessoa(pessoaDtoUnico);
    }

    private void updatePessoaUnico(br.com.elotech.protocolo.dto.PessoaDTO pessoaDTO, boolean isIntegradoTributario) {
        Pessoa pessoaProtocolo = (Pessoa)this.getPessoas().findOne((Object)pessoaDTO.getId());
        PessoaClientUnico pessoaClientUnico = this.getPessoaClientUnico();
        PessoaDTO pessoaUnico = pessoaClientUnico.getPessoaById(pessoaProtocolo.getIdUnico());
        pessoaClientUnico.ativaProtocolo(pessoaUnico);
        if (isIntegradoTributario) {
            pessoaClientUnico.ativaContribuinte(pessoaUnico);
        }
        if (pessoaUnico.getDataNascimento() == null && pessoaDTO.getDataNascimento() != null) {
            List<JsonUpdatePartial> updatesDtNasc = Collections.singletonList(JsonUpdatePartial.replace((String)"/dataNascimento", (String)pessoaDTO.getDataNascimento().toString()));
            pessoaClientUnico.patchPessoa(pessoaUnico.getId(), updatesDtNasc);
        }
        Optional pessoaContatoOpt = Optional.ofNullable(pessoaUnico.getContatos()).flatMap(pessoaContatoDTOS -> pessoaContatoDTOS.stream().filter(PessoaContatoDTO::getPrincipal).findFirst());
        pessoaContatoOpt.ifPresentOrElse(pessoaContato -> this.updateContatoUnico(pessoaDTO, pessoaUnico, pessoaContato), () -> this.createContatoUnico(pessoaDTO, pessoaUnico));
    }
}

