/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.EnderecoPessoa;
import br.com.elotech.protocolo.domain.Parametro;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.PessoaDTO;
import br.com.elotech.protocolo.dto.PessoaTributosDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.ProcessoInteressadoDTO;
import br.com.elotech.protocolo.function.PessoaToTributosDTO;
import br.com.elotech.protocolo.repository.PessoaRepository;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.PessoaAtualizadorService;
import br.com.elotech.protocolo.service.PessoaProcessoExternoService;
import br.com.elotech.protocolo.service.PessoaService;
import br.com.elotech.protocolo.service.TributosService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.persistence.EntityManager;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"standalone"})
public class PessoaStandaloneService
extends CrudService<Pessoa, Long>
implements PessoaService {
    private final PessoaAtualizadorService pessoaAtualizadorService;
    private final EntityManager em;
    private final ProtocoloMapper protocoloMapper;
    private final ParametroService parametroService;
    private final ExercicioService exercicioService;
    private final TributosService tributosService;
    private final PessoaProcessoExternoService pessoaProcessoExternoService;

    public PessoaStandaloneService(ProtocoloMapper protocoloMapper, EntityManager em, PessoaAtualizadorService pessoaAtualizadorService, ParametroService parametroService, ExercicioService exercicioService, TributosService tributosService, PessoaProcessoExternoService pessoaProcessoExternoService) {
        this.protocoloMapper = protocoloMapper;
        this.em = em;
        this.pessoaAtualizadorService = pessoaAtualizadorService;
        this.exercicioService = exercicioService;
        this.parametroService = parametroService;
        this.tributosService = tributosService;
        this.pessoaProcessoExternoService = pessoaProcessoExternoService;
    }

    public PessoaRepository getPessoas() {
        return (PessoaRepository)this.getCrudRepository();
    }

    protected void beforeSave(Pessoa entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        this.em.clear();
        List pessoasDuplicadas = this.getPessoaDuplicateByCpfCnpj(entity.getCnpjCpf());
        if (!pessoasDuplicadas.isEmpty() && entity.getCnpjCpf().equals(((Pessoa)pessoasDuplicadas.get(0)).getCnpjCpf()) && !((Pessoa)pessoasDuplicadas.get(0)).getId().equals(entity.getId())) {
            throw new EloValidationException("J\u00e1 existe uma pessoa com o mesmo CNPJ/CPF!");
        }
        List enderecos = entity.getEnderecos();
        if (enderecos.isEmpty()) {
            if (!this.permiteGravarSemEndereco().booleanValue()) {
                throw new EloValidationException("Endere\u00e7o Obrigat\u00f3rio para o Cadastro da Pessoa.");
            }
            if (this.tributosService.integradoTributos()) {
                throw new EloValidationException("Sistema Integrado com Tributos n\u00e3o Permitido Cadastro sem Endere\u00e7o.");
            }
        }
        for (EnderecoPessoa endereco : entity.getEnderecos()) {
            if (entity.equals((Object)endereco.getPk().getPessoa())) continue;
            endereco.getPk().setPessoa(entity);
        }
        entity.getEnderecos().sort(Comparator.comparing(EnderecoPessoa::getId, Comparator.nullsLast(Comparator.naturalOrder())));
        boolean sequenciaPrincipalFoiAlterada = entity.getEnderecos().stream().map(EnderecoPessoa::getId).filter(Objects::nonNull).noneMatch(id -> id.equals(entity.getSequenciaEndereco()));
        IntStream.range(0, entity.getEnderecos().size()).forEach(index -> ((EnderecoPessoa)entity.getEnderecos().get(index)).getPk().setCodigo(Long.valueOf(++index)));
        if ((entity.isNew() || entity.getSequenciaEndereco() == null || sequenciaPrincipalFoiAlterada) && !enderecos.isEmpty()) {
            entity.setSequenciaEndereco(Optional.ofNullable(((EnderecoPessoa)enderecos.get(0)).getId()).orElse(1L));
        }
    }

    private Boolean permiteGravarSemEndereco() {
        Parametro naoValidaEndereco = this.parametroService.getByEntidadeAndExercicioAndCodigo(RequestHeaderHelper.getEntidadeContextHolder(), this.exercicioService.getExercicioAtual(), ParametroEnum.NAO_OBRIGA_ENDERECO.getCodigo());
        Parametro paramDefault = new Parametro();
        paramDefault.setValor("N");
        return Optional.ofNullable(naoValidaEndereco).orElse(paramDefault).getValor().equalsIgnoreCase("S");
    }

    public List<Pessoa> getPessoaDuplicateByCpfCnpj(String cnpjCpf) {
        return this.getPessoas().findAllBycnpjCpf(cnpjCpf);
    }

    public List<Pessoa> getPessoaByCnpjCpfOrderById(String cnpjCpf) {
        return this.getPessoas().findAllByCnpjCpfOrderById(cnpjCpf);
    }

    public List<Pessoa> findAllByAtivoIsTrueAndCnpjCpfOrderById(String cnpjCpf) {
        return this.getPessoas().findAllByAtivoIsTrueAndCnpjCpfOrderById(cnpjCpf);
    }

    public PessoaDTO savePessoa(PessoaDTO pessoaDTO) {
        List pessoas = this.getPessoaByCnpjCpfOrderById(pessoaDTO.getCnpjCpf());
        if (pessoas.isEmpty()) {
            Pessoa pessoa = this.protocoloMapper.toPessoa(pessoaDTO);
            if (this.tributosService.integradoTributos()) {
                List existentes;
                PessoaTributosDTO pessoaTributos = new PessoaToTributosDTO().apply(pessoa);
                Optional ca = this.tributosService.salvarPessoaCadastroAvulsoTributos(pessoaTributos);
                if (ca.isPresent() && !(existentes = this.getPessoas().findAllBycnpjCpf(pessoaTributos.getCnpjCpf())).isEmpty()) {
                    pessoa = (Pessoa)existentes.get(0);
                }
                return this.protocoloMapper.toPessoaDTO((Pessoa)this.getPessoas().save((Object)pessoa));
            }
            return this.protocoloMapper.toPessoaDTO((Pessoa)this.getPessoas().save((Object)pessoa));
        }
        if (Objects.isNull(pessoaDTO.getId())) {
            pessoaDTO.setId(((Pessoa)pessoas.get(0)).getId());
        }
        return this.pessoaAtualizadorService.save(pessoaDTO);
    }

    public PessoaDTO savePessoaProcessoExterno(ProcessoDTO processoDTO) {
        PessoaDTO pessoaDTO = this.pessoaProcessoExternoService.prepararPessoaDtoParaSalvar(processoDTO);
        return this.savePessoa(pessoaDTO);
    }

    public PessoaDTO savePessoaProcessoInteressadoExterno(ProcessoInteressadoDTO interessadoDTO) {
        PessoaDTO pessoaDto = interessadoDTO.getPessoa();
        pessoaDto.definirTipoPessoa();
        return this.savePessoa(pessoaDto);
    }
}

