/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.protocolo.domain.Bairro;
import br.com.elotech.protocolo.domain.Cidade;
import br.com.elotech.protocolo.domain.EnderecoPessoa;
import br.com.elotech.protocolo.domain.Logradouro;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.TipoLogradouro;
import br.com.elotech.protocolo.domain.UnidadeFederacao;
import br.com.elotech.protocolo.dto.PessoaDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.service.BairroService;
import br.com.elotech.protocolo.service.CidadeService;
import br.com.elotech.protocolo.service.LogradouroService;
import br.com.elotech.protocolo.service.ProtocoloConfigService;
import br.com.elotech.protocolo.service.UnidadeFederacaoService;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PessoaProcessoExternoService {
    private static final int TAMANHO_CPF = 11;
    private final LogradouroService logradouroService;
    private final CidadeService cidadeService;
    private final BairroService bairroService;
    private final UnidadeFederacaoService unidadeFederacaoService;
    private final ProtocoloMapper mapper;
    private final ProtocoloConfigService protocoloConfigService;

    public PessoaDTO prepararPessoaDtoParaSalvar(ProcessoDTO processo) {
        PessoaDTO pessoa;
        pessoa.setTipoPessoa(StringUtils.length((CharSequence)(pessoa = processo.getPessoa()).getCnpjCpf()) <= 11 ? TipoPessoa.FISICA : TipoPessoa.JURIDICA);
        if (this.enderecoEstaPreenchido(processo)) {
            EnderecoPessoa endereco = this.getEnderecoPessoa(processo);
            pessoa.getEnderecos().add(this.mapper.toEnderecoPessoaDTO(endereco));
        }
        return pessoa;
    }

    private boolean enderecoEstaPreenchido(ProcessoDTO processo) {
        boolean todosOsCamposEmBranco = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{processo.getEndereco(), processo.getNumeroEndereco(), processo.getCep(), processo.getBairroAux(), processo.getCidadeAux(), processo.getUf()});
        if (todosOsCamposEmBranco && this.protocoloConfigService.isEnderecoRequired()) {
            throw new EloValidationException("Endere\u00e7o \u00e9 obrigat\u00f3rio para o processo externo.");
        }
        return !todosOsCamposEmBranco;
    }

    private EnderecoPessoa getEnderecoPessoa(ProcessoDTO processo) {
        EnderecoPessoa endereco = new EnderecoPessoa();
        Optional unidades = this.unidadeFederacaoService.findByDescricao(processo.getUf()).stream().findFirst();
        if (unidades.isPresent()) {
            endereco.setUf((UnidadeFederacao)unidades.get());
        } else {
            UnidadeFederacao unidade = new UnidadeFederacao();
            unidade.setDescricao(processo.getUf());
            unidade.setId(processo.getUf());
            endereco.setUf((UnidadeFederacao)this.unidadeFederacaoService.save((EloEntity)unidade, null));
        }
        Optional cidades = this.cidadeService.findByDescricaoAndUnidadeFederacao(processo.getCidadeAux(), endereco.getUf()).stream().findFirst();
        if (cidades.isPresent()) {
            endereco.setCidade((Cidade)cidades.get());
        } else {
            Cidade cidade = new Cidade();
            cidade.setDescricao(processo.getCidadeAux());
            cidade.setUf(endereco.getUf());
            endereco.setCidade((Cidade)this.cidadeService.save((EloEntity)cidade, null));
        }
        Optional bairros = this.bairroService.findByDescricaoAndCidade(processo.getBairroAux(), endereco.getCidade()).stream().findFirst();
        if (bairros.isPresent()) {
            endereco.setBairro((Bairro)bairros.get());
        } else {
            Bairro bairro = new Bairro();
            bairro.setDescricao(processo.getBairroAux());
            bairro.setCidade(endereco.getCidade());
            endereco.setBairro((Bairro)this.bairroService.save((EloEntity)bairro, null));
        }
        Optional logradouros = this.logradouroService.findByDescricaoAndCidade(processo.getEndereco(), endereco.getCidade()).stream().findFirst();
        if (logradouros.isPresent()) {
            endereco.setLogradouro((Logradouro)logradouros.get());
        } else {
            Logradouro logradouro = new Logradouro();
            logradouro.setDescricao(processo.getEndereco());
            logradouro.setCidade(endereco.getCidade());
            logradouro.setBairro(endereco.getBairro().getId());
            TipoLogradouro tipoLogradouro = new TipoLogradouro();
            tipoLogradouro.setId(Long.valueOf(1L));
            logradouro.setTipoLogradouro(tipoLogradouro);
            endereco.setLogradouro((Logradouro)this.logradouroService.save((EloEntity)logradouro, null));
        }
        endereco.setComplemento(processo.getComplemento());
        endereco.setNumero(processo.getNumeroEndereco());
        endereco.setCep(processo.getCep());
        return endereco;
    }

    @Generated
    public PessoaProcessoExternoService(LogradouroService logradouroService, CidadeService cidadeService, BairroService bairroService, UnidadeFederacaoService unidadeFederacaoService, ProtocoloMapper mapper, ProtocoloConfigService protocoloConfigService) {
        this.logradouroService = logradouroService;
        this.cidadeService = cidadeService;
        this.bairroService = bairroService;
        this.unidadeFederacaoService = unidadeFederacaoService;
        this.mapper = mapper;
        this.protocoloConfigService = protocoloConfigService;
    }
}

