/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.PessoaAtualizador;
import br.com.elotech.protocolo.dto.PessoaDTO;
import br.com.elotech.protocolo.repository.PessoaAtualizadorRepository;
import br.com.elotech.protocolo.repository.PessoaRepository;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;

@Service
public class PessoaAtualizadorService {
    private final PessoaAtualizadorRepository repository;
    private final PessoaRepository pessoaRepository;

    public PessoaAtualizadorService(PessoaAtualizadorRepository repository, PessoaRepository pessoaRepository) {
        this.repository = repository;
        this.pessoaRepository = pessoaRepository;
    }

    public Optional<PessoaAtualizador> findOne(Long id) {
        return this.repository.findById((Object)id);
    }

    public Optional<Pessoa> findOnePessoa(Long id) {
        return this.pessoaRepository.findById((Object)id);
    }

    public List<PessoaAtualizador> findAllAtualizacoesPessoa(String cpfCnpj) {
        return this.repository.findByCpfCnpjAndAtualizadoFalse(cpfCnpj);
    }

    public PessoaDTO save(PessoaDTO pessoa) {
        List atualizacoesPessoa = this.repository.findByCpfCnpjAndAtualizadoFalse(pessoa.getCnpjCpf());
        if (atualizacoesPessoa.isEmpty()) {
            PessoaAtualizador novaAtualizacao = new PessoaAtualizador();
            novaAtualizacao.pessoaAtualizadorByPessoa(pessoa);
            this.repository.save((Object)novaAtualizacao);
            return pessoa;
        }
        PessoaAtualizador pessoaAtualizador = (PessoaAtualizador)atualizacoesPessoa.get(0);
        pessoaAtualizador.pessoaAtualizadorByPessoa(pessoa);
        this.repository.save((Object)pessoaAtualizador);
        return pessoa;
    }

    @Transactional
    public Pessoa atualizarPessoa(Pessoa pessoa, PessoaAtualizador atualizador, String usuario) {
        pessoa.alterarPessoaByAtualizador(atualizador);
        atualizador.setUsuarioAtualizacao(usuario);
        atualizador.setAtualizado(Boolean.TRUE);
        atualizador.setDataAtualizacao(LocalDateTime.now());
        this.repository.save((Object)atualizador);
        return (Pessoa)this.pessoaRepository.save((Object)pessoa);
    }

    public List<PessoaAtualizador> findAll() {
        return this.repository.findByAtualizadoFalse();
    }
}

