/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.parametro.BaseParametroService;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.LocalPK;
import br.com.elotech.protocolo.domain.Parametro;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.ParametroPK;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.RoteiroLocal;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.ConfigLGPDCPFCNPJ;
import br.com.elotech.protocolo.enums.ParametroSistemaEnum;
import br.com.elotech.protocolo.repository.LocalRepository;
import br.com.elotech.protocolo.repository.ParametroRepository;
import br.com.elotech.protocolo.repository.PessoaRepository;
import br.com.elotech.protocolo.repository.SituacaoRepository;
import br.com.elotech.protocolo.repository.TipoProcessoRepository;
import br.com.elotech.protocolo.service.AgendamentoService;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.RoteiroLocalService;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ParametroService
extends BaseParametroService<ParametroEnum, Parametro, ParametroPK> {
    private final ParametroRepository parametroRepository;
    private final ExercicioService exercicioService;
    private final EntidadeService entidadeService;
    private final RoteiroLocalService roteiroLocalService;
    private final TipoProcessoRepository tipoProcessoRepository;
    private final SituacaoRepository situacaoRepository;
    private final LocalRepository localRepository;
    private final PessoaRepository pessoaRepository;
    private final AgendamentoService agendamentoService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ParametroService.class);
    private static final String MESSAGE_WARN = "Par\u00e2metro {} n\u00e3o est\u00e1 configurado";
    private static final Long VALOR_DEFAULT_ENT_PROC_EXTERNO = 1L;
    private static final Long VALOR_DEFAULT_TIPO_PROC_EXTERNO = 1L;
    private static final Long VALOR_DEFAULT_SITUACAO_PROC_EXTERNO = 1L;
    private static final Long VALOR_DEFAULT_LOCAL_PROC_EXTERNO = 1L;

    @Autowired
    public ParametroService(ParametroRepository parametroRepository, EntidadeService entidadeService, ExercicioService exercicioService, RoteiroLocalService roteiroLocalService, TipoProcessoRepository tipoProcessoRepository, SituacaoRepository situacaoRepository, LocalRepository localRepository, PessoaRepository pessoaRepository, @Lazy AgendamentoService agendamentoService) {
        this.parametroRepository = parametroRepository;
        this.exercicioService = exercicioService;
        this.entidadeService = entidadeService;
        this.roteiroLocalService = roteiroLocalService;
        this.tipoProcessoRepository = tipoProcessoRepository;
        this.situacaoRepository = situacaoRepository;
        this.localRepository = localRepository;
        this.pessoaRepository = pessoaRepository;
        this.agendamentoService = agendamentoService;
    }

    public Parametro getByEntidadeAndExercicioAndCodigo(Entidade entidade, Long exercicio, Long codigo) {
        return (Parametro)this.findOneOrDefault(codigo, entidade.getId(), exercicio);
    }

    public Parametro getByCodigo(Long codigo) {
        return this.getByEntidadeAndExercicioAndCodigo(this.entidadeService.getEntidadeAtual(), this.exercicioService.getExercicioAtual(), codigo);
    }

    public String getParamValueAsString(Long codigo) {
        Long exercicioAtual = this.exercicioService.getExercicioAtual();
        return this.getByEntidadeAndExercicioAndCodigo(this.entidadeService.getEntidadeAtual(), exercicioAtual, codigo).getValor();
    }

    public Long getParamValueAsLong(Long codigo) {
        return this.getParamValueAsLong(codigo, this.entidadeService.getEntidadeLogada(), this.exercicioService.getExercicioAtual());
    }

    public Long getParamValueAsLong(Long codigo, Long entidade, Long exercicio) {
        Parametro param = (Parametro)this.findOneOrDefault(codigo, entidade, exercicio);
        if (param.isValorNullOrEmpty().booleanValue()) {
            return null;
        }
        return Long.valueOf(param.getValor());
    }

    public Boolean getParamValueAsBoolean(Long codigo) {
        return this.getParamValueAsBoolean(codigo, this.entidadeService.getEntidadeLogada(), this.exercicioService.getExercicioAtual());
    }

    public Boolean getParamValueAsBoolean(ParametroEnum parametroEnum, Entidade entidade, Long exercicio) {
        return this.getParamValueAsBoolean(parametroEnum.getCodigo(), entidade.getId(), exercicio);
    }

    public List<Parametro> findAllList(Entidade entidade, Long ano) {
        return this.findAllOrDefaults(entidade.getId(), ano).stream().filter(parametro -> ParametroSistemaEnum.OXY.equals((Object)parametro.getSistema()) || ParametroSistemaEnum.AMBOS.equals((Object)parametro.getSistema()) || ParametroSistemaEnum.PORTAL.equals((Object)parametro.getSistema())).collect(Collectors.toList());
    }

    public Long getParamLongEntidadeProcessoExterno() {
        return this.getParamLongEntidadeOrDefault(ParametroEnum.PROCESSO_EXTERNO_ENTIDADE);
    }

    public Long getParamLongEntidadeProcessoOuvidoria() {
        return this.getParamLongEntidadeOrDefault(ParametroEnum.ENTIDADE_OUVIDORIA);
    }

    private Long getParamLongEntidadeOrDefault(ParametroEnum parametroEntidade) {
        Long paramValue = this.getParamValueAsLong(parametroEntidade.getCodigo());
        if (paramValue == null) {
            long entidade = ContextHolder.getHeaderValueEntidade().intValue();
            return entidade > 0L ? entidade : VALOR_DEFAULT_ENT_PROC_EXTERNO;
        }
        return paramValue;
    }

    public TipoProcesso getParamTipoProcessoExterno(Entidade entidade) {
        String parametroTipoProcesso = this.getParamValueOrDefault(entidade, ParametroEnum.PROCESSO_EXTERNO_TIPO_PROCESSO, VALOR_DEFAULT_TIPO_PROC_EXTERNO.toString());
        return (TipoProcesso)this.tipoProcessoRepository.findOne((Object)Long.valueOf(parametroTipoProcesso));
    }

    public TipoProcesso getParamTipoProcessoOuvidoria(Entidade entidade) {
        String parametroProcessoOuvidoria = this.getParamValueOrDefault(entidade, ParametroEnum.TIPO_PROCESSO_OUVIDORIA, VALOR_DEFAULT_TIPO_PROC_EXTERNO.toString());
        return (TipoProcesso)this.tipoProcessoRepository.findOne((Object)Long.valueOf(parametroProcessoOuvidoria));
    }

    public Situacao getParamSituacaoProcessoExterno(Entidade entidade) {
        String parametroSituacao = this.getParamValueOrDefault(entidade, ParametroEnum.SITUACAO_PADRAO, VALOR_DEFAULT_SITUACAO_PROC_EXTERNO.toString());
        return (Situacao)this.situacaoRepository.findOne((Object)Long.valueOf(parametroSituacao));
    }

    public Local getParamLocalOrigemProcessoExterno(Entidade entidade) {
        String parametroLocalOrigem = this.getParamValueOrDefault(entidade, ParametroEnum.PROCESSO_EXTERNO_LOCAL_ORIGEM, VALOR_DEFAULT_LOCAL_PROC_EXTERNO.toString());
        return (Local)this.localRepository.findOne((Object)LocalPK.of((Entidade)entidade, (Long)Long.valueOf(parametroLocalOrigem)));
    }

    public Local getParamLocalDestinoProcessoExterno(Entidade entidade, Assunto assunto) {
        RoteiroLocal roteiroLocal = this.roteiroLocalService.getRoteiroInicial(entidade, assunto);
        if (Objects.isNull(roteiroLocal)) {
            String parametroLocalDestino = this.getParamValueOrDefault(entidade, ParametroEnum.PROCESSO_EXTERNO_LOCAL_DESTINO, VALOR_DEFAULT_LOCAL_PROC_EXTERNO.toString());
            return (Local)this.localRepository.findOne((Object)LocalPK.of((Entidade)entidade, (Long)Long.valueOf(parametroLocalDestino)));
        }
        return roteiroLocal.getLocal();
    }

    public Pessoa getParamPessoaAnonima(Entidade entidade) {
        String parametroPessoaAnonima = this.getParamValueOrDefault(entidade, ParametroEnum.PESSOA_ANONIMA, null);
        if (Objects.isNull(parametroPessoaAnonima)) {
            throw new RestException(HttpStatus.PRECONDITION_FAILED, "N\u00e3o foi Informado Nenhuma Pessoa An\u00f4nima para o Processo.");
        }
        return (Pessoa)this.pessoaRepository.findOne((Object)Long.valueOf(parametroPessoaAnonima));
    }

    public Local getParamLocalOrigemProcessoOuvidoria(Entidade entidade) {
        String parametroLocalOrigem = this.getParamValueOrDefault(entidade, ParametroEnum.LOCAL_ORIGEM_OUVIDORIA, VALOR_DEFAULT_LOCAL_PROC_EXTERNO.toString());
        return (Local)this.localRepository.findOne((Object)LocalPK.of((Entidade)entidade, (Long)Long.valueOf(parametroLocalOrigem)));
    }

    public Local getParamLocalDestinoProcessoOuvidoria(Entidade entidade, Assunto assunto) {
        RoteiroLocal roteiroLocal = this.roteiroLocalService.getRoteiroInicial(entidade, assunto);
        if (Objects.isNull(roteiroLocal)) {
            String parametroLocalDestino = this.getParamValueOrDefault(entidade, ParametroEnum.LOCAL_DESTINO_OUVIDORIA, VALOR_DEFAULT_LOCAL_PROC_EXTERNO.toString());
            return (Local)this.localRepository.findOne((Object)LocalPK.of((Entidade)entidade, (Long)Long.valueOf(parametroLocalDestino)));
        }
        return roteiroLocal.getLocal();
    }

    public ConfigLGPDCPFCNPJ getConfigLgpdcpfcnpj() {
        return ConfigLGPDCPFCNPJ.builder().escondeNumeroCPF(this.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CPF_LGPD.getCodigo())).escondeNumeroCNPJ(this.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CNPJ_LGPD.getCodigo())).escondeNumeroLogin(this.getParamValueAsBoolean(ParametroEnum.EXIBE_USUARIO_COM_MASCARA_COM_CPF_LGPD.getCodigo())).build();
    }

    public void actionsParametrosAlterados(List<Parametro> parametrosAlterados) {
        if (parametrosAlterados.stream().anyMatch(p -> this.vericaEhParametroEmailProcessosEmAtraso(p.getId().getId()))) {
            this.agendamentoService.verificaAgendamentoEmailProcessosEmAtraso(this.existeParametroEmailProcessosEmAtrasoHabilitado());
        }
    }

    private boolean vericaEhParametroEmailProcessosEmAtraso(Long codigo) {
        return ParametroEnum.AVISA_POR_EMAIL_REQUERENTE_PROCESSO_ATRASO.getCodigo().equals(codigo) || ParametroEnum.AVISA_POR_EMAIL_RESPONSAVEIS_LOCAL_PROCESSO_ATRASO.getCodigo().equals(codigo) || ParametroEnum.AVISA_POR_EMAIL_LOCAL_PROCESSO_ATRASO.getCodigo().equals(codigo);
    }

    private boolean existeParametroEmailProcessosEmAtrasoHabilitado() {
        return Boolean.TRUE.equals(this.getParamValueAsBoolean(ParametroEnum.AVISA_POR_EMAIL_REQUERENTE_PROCESSO_ATRASO.getCodigo())) || Boolean.TRUE.equals(this.getParamValueAsBoolean(ParametroEnum.AVISA_POR_EMAIL_RESPONSAVEIS_LOCAL_PROCESSO_ATRASO.getCodigo())) || Boolean.TRUE.equals(this.getParamValueAsBoolean(ParametroEnum.AVISA_POR_EMAIL_LOCAL_PROCESSO_ATRASO.getCodigo()));
    }

    private String getParamValueOrDefault(Entidade entidade, ParametroEnum parametroEnum, String defaultValue) {
        Parametro parametro = this.getByEntidadeAndExercicioAndCodigo(entidade, Long.valueOf(LocalDate.now().getYear()), parametroEnum.getCodigo());
        String valor = Optional.ofNullable(parametro).filter(parametro1 -> parametro1.isValorNullOrEmpty() == false).map(Parametro::getValor).orElse(defaultValue);
        if (Objects.equals(defaultValue, valor)) {
            LOGGER.warn(MESSAGE_WARN, (Object)parametroEnum.getDescricao());
        }
        return valor;
    }

    protected ModuloEnum getModulo() {
        return ModuloEnum.MODULO_PROTOCOLO;
    }

    protected List<ParametroEnum> getEnumValues() {
        return List.of(ParametroEnum.values());
    }

    protected void beforeSaveAll(List<Parametro> parametros) {
    }

    protected Parametro findOneByCodigoAndEntidadeAndExercicio(Long codigo, Long entidade, Long exercicio) {
        return this.parametroRepository.findTop1ByIdIdAndIdEntidadeIdAndIdModuloIdAndIdExercicioLessThanEqualOrderByIdExercicioDesc(codigo, entidade, this.getModulo().getValue(), exercicio);
    }

    protected List<Parametro> findAllByEntidadeAndExercicio(Long entidade, Long exercicio) {
        return this.parametroRepository.findAllByIdEntidadeAndIdModuloWithMaxExercicio(entidade, exercicio, this.getModulo().getValue());
    }

    protected Parametro getDefault(Long codigo, Long entidade, Long exercicio) {
        ParametroEnum parametroEnum = ParametroEnum.fromCodigo((Long)codigo);
        if (Objects.isNull(parametroEnum)) {
            return null;
        }
        return Parametro.of((ParametroEnum)parametroEnum, (Long)entidade, (Long)exercicio, (String)this.getModulo().getValue());
    }
}

