/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ModeloImpressao;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.domain.UsuarioModeloImpressao;
import br.com.elotech.protocolo.domain.UsuarioModeloImpressaoPK;
import br.com.elotech.protocolo.enums.TipoModeloImpressaoEnum;
import br.com.elotech.protocolo.repository.ModeloImpressaoRepository;
import br.com.elotech.protocolo.repository.UsuarioModeloImpressaoRepository;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.UsuarioService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ModeloImpressaoService
extends CrudService<ModeloImpressao, Long> {
    private final EntidadeService entidadeService;
    private final UsuarioService usuarioService;
    private final UsuarioModeloImpressaoRepository usuarioModeloImpressaoRepository;
    private final ModeloImpressaoRepository modeloImpressaoRepository;

    public ModeloImpressaoService(EntidadeService entidadeService, UsuarioService usuarioService, UsuarioModeloImpressaoRepository usuarioModeloImpressaoRepository, ModeloImpressaoRepository modeloImpressaoRepository) {
        this.entidadeService = entidadeService;
        this.usuarioService = usuarioService;
        this.usuarioModeloImpressaoRepository = usuarioModeloImpressaoRepository;
        this.modeloImpressaoRepository = modeloImpressaoRepository;
    }

    public ModeloImpressao initializeTemplate(Authentication auth) {
        ModeloImpressao modeloImpressao = (ModeloImpressao)super.initializeTemplate(auth);
        modeloImpressao.setEntidade(this.entidadeService.getEntidadeAtual());
        return modeloImpressao;
    }

    protected void beforeSave(ModeloImpressao entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        Boolean exists = this.modeloImpressaoRepository.findByDescricaoAndModelo(entity.getId(), entity.getDescricao(), entity.getModelo());
        if (Boolean.TRUE.equals(exists)) {
            throw new RestException(HttpStatus.BAD_REQUEST, String.format("J\u00e1 existe um cadastro com esta descri\u00e7\u00e3o: %s e modelo: %s.", entity.getDescricao(), entity.getModelo()));
        }
    }

    public List<ModeloImpressao> searchRptCustom(String tipo, Entidade entidade, String usuario) {
        Usuario usuarioLogado = this.usuarioService.findUsuarioByName(usuario);
        List listaPorUsuario = this.usuarioModeloImpressaoRepository.findByIdUsuarioAndIdModeloImpressaoTipo(usuarioLogado, TipoModeloImpressaoEnum.fromDescricao((String)tipo));
        List listaModeloImpressao = listaPorUsuario.stream().map(UsuarioModeloImpressao::getId).map(UsuarioModeloImpressaoPK::getModeloImpressao).collect(Collectors.toList());
        if (listaModeloImpressao.isEmpty()) {
            listaModeloImpressao = this.modeloImpressaoRepository.findByEntidadeAndTipoAndAtivoIsTrue(entidade, TipoModeloImpressaoEnum.fromDescricao((String)tipo));
        }
        return listaModeloImpressao;
    }
}

