/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.domain.dto.EntidadeDTO;
import br.com.elotech.adm.exporter.FileExportExecutorDTO;
import br.com.elotech.adm.service.ModeloExporterDefaultService;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.service.EntidadeService;
import java.util.Optional;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ModeloExporterService
extends ModeloExporterDefaultService {
    private final EntidadeService entidadeService;

    public ModeloExporterService(EntidadeService entidadeService) {
        this.entidadeService = entidadeService;
    }

    public void configFileExportExecutor(FileExportExecutorDTO fileExportExecutor) {
        Entidade entidadeLogada = this.entidadeService.getEntidadeAtual();
        EntidadeDTO entidadeDTO = new EntidadeDTO();
        entidadeDTO.setBrasao(entidadeLogada.getBrasao());
        entidadeDTO.setNome(entidadeLogada.getNome());
        entidadeDTO.setNumero(entidadeLogada.getNumero());
        Optional.ofNullable(entidadeLogada.getLogradouro()).ifPresent(logradouro -> entidadeDTO.setLogradouroDescricao(logradouro.getDescricao()));
        Optional.ofNullable(entidadeLogada.getCidade()).ifPresent(cidade -> {
            entidadeDTO.setCidadeDescricao(cidade.getDescricao());
            Optional.ofNullable(cidade.getUf()).ifPresent(uf -> entidadeDTO.setSiglaUnidadeFederacaoCidade(uf.getId()));
        });
        fileExportExecutor.setEntidade(entidadeDTO);
        fileExportExecutor.setUserName(SecurityContextHolder.getContext().getAuthentication().getName());
    }
}

