/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.domain.dto.OfficeDTO;
import br.com.elotech.adm.enums.MimeTypeEnum;
import br.com.elotech.adm.exception.CriacaoNaoPermitidaException;
import br.com.elotech.adm.modelodados.domain.ModeloDadosResultDTO;
import br.com.elotech.adm.modelodados.enums.TipoModeloEnum;
import br.com.elotech.adm.modelodados.exception.ModeloDadosException;
import br.com.elotech.adm.utils.LibreOfficeUtils;
import br.com.elotech.adm.utils.WordOfficeUtils;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.metamodel.MetaModelField;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.protocolo.domain.ModeloAssunto;
import br.com.elotech.protocolo.domain.ModeloDados;
import br.com.elotech.protocolo.domain.ModeloDadosArquivo;
import br.com.elotech.protocolo.domain.SqlModelo;
import br.com.elotech.protocolo.domain.VariavelSqlModelo;
import br.com.elotech.protocolo.dto.ModeloParamsDTO;
import br.com.elotech.protocolo.enums.TipoVariavel;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.repository.ModeloDadosArquivoRepository;
import br.com.elotech.protocolo.repository.ModeloDadosRepository;
import br.com.elotech.protocolo.repository.VariavelSqlModeloRepository;
import br.com.elotech.protocolo.service.arquivo.ArquivoService;
import br.com.elotech.protocolo.utils.ByteMultipartFile;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import br.com.elotech.unico.client.dto.EloArquivoContentDTO;
import br.com.elotech.unico.client.dto.EloArquivoDTO;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;

@Service
public class ModeloDadosService
extends ReadOnlyService<ModeloDados, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModeloDadosService.class);
    private static final String REGEX_VARIABLES_GROUP = "variable";
    private static final String REGEX_VARIABLES = "\\[\\[(?<variable>[a-zA-Z0-9.]*)\\]\\]";
    private static final String REGEX_TABLES_GROUP = "table";
    private static final String REGEX_TABLES = "\\[\\[(?<table>tabela_[a-zA-Z0-9]*)\\]\\]";
    private final ArquivoService arquivoService;
    private final ModeloDadosArquivoRepository modeloDadosArquivoRepository;
    private final VariavelSqlModeloRepository variavelSqlModeloRepository;
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public ModeloDadosService(ArquivoService arquivoService, ModeloDadosArquivoRepository modeloDadosArquivoRepository, VariavelSqlModeloRepository variavelSqlModeloRepository, NamedParameterJdbcTemplate jdbcTemplate) {
        this.arquivoService = arquivoService;
        this.modeloDadosArquivoRepository = modeloDadosArquivoRepository;
        this.variavelSqlModeloRepository = variavelSqlModeloRepository;
        this.jdbcTemplate = jdbcTemplate;
    }

    public ModeloDadosRepository getRepository() {
        return (ModeloDadosRepository)super.getRepository();
    }

    public String processarModeloDados(ModeloParamsDTO params) {
        List modeloDadosArquivos = this.modeloDadosArquivoRepository.findAllByModeloId(params.getModeloDados().getId()).stream().sorted(Comparator.comparing(ModeloDadosArquivo::getDataCriacao).reversed()).collect(Collectors.toList());
        if (modeloDadosArquivos.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel processar o modelo. Motivo: Arquivos do Modelo n\u00e3o encontrados ou inv\u00e1lidos.");
        }
        Optional arquivoContentByEntityArquivo = this.arquivoService.downloadArquivo(((ModeloDadosArquivo)modeloDadosArquivos.get(0)).getIdArquivo());
        if (arquivoContentByEntityArquivo.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel processar o modelo. Motivo: Arquivo n\u00e3o encontrado.");
        }
        String htmlModelo = new String(((EloArquivoDTO)arquivoContentByEntityArquivo.get()).getContent().getBinary(), Charset.defaultCharset());
        Map variaveisModelo = this.getVariaveisModelo(htmlModelo);
        String htmlVariaveisThymeleaf = this.getHtmlModeloSubstituindoSnippets(variaveisModelo, htmlModelo);
        br.com.elotech.protocolo.dto.ModeloDadosResultDTO dados = this.loadDataFromSql(params);
        Context context = new Context();
        context.setVariable("data", (Object)dados.getData());
        context.setVariable("metadata", (Object)dados.getMetadata());
        ITemplateEngine templateEngine = this.createTemplateEngine();
        try {
            return templateEngine.process(htmlVariaveisThymeleaf, (IContext)context);
        }
        catch (Exception e) {
            throw new ModeloDadosException(e.getMessage());
        }
    }

    private String getHtmlModeloSubstituindoSnippets(Map<TipoVariavel, Set<String>> variaveisModelo, String template) {
        String snippetTabela = FileUtils.readResourceAsString((String)"templates/snippets/tabela.html");
        String snippetPrimitivo = FileUtils.readResourceAsString((String)"templates/snippets/primitivo.html");
        String novoTemplate = template;
        for (Map.Entry<TipoVariavel, Set<String>> entry : variaveisModelo.entrySet()) {
            boolean isTabela = entry.getKey() == TipoVariavel.TABELA;
            for (String variavel : entry.getValue()) {
                String snippet;
                if (isTabela) {
                    snippet = snippetTabela.replace("itens", variavel.substring(variavel.lastIndexOf(91) + 1, variavel.indexOf(93)));
                } else {
                    String variavelSemMarcador = variavel.replaceAll("\\[\\[", "#{").replaceAll("\\]\\]", "}");
                    String variavelSomentePrimitivos = variavelSemMarcador.substring(variavelSemMarcador.lastIndexOf(".") + 1, variavelSemMarcador.length() - 1);
                    String nomeDataset = variavelSemMarcador.substring(2, variavelSemMarcador.indexOf("."));
                    snippet = snippetPrimitivo.replace("PROPERTY", variavelSomentePrimitivos.toUpperCase()).replace("DATASET", nomeDataset);
                }
                novoTemplate = novoTemplate.replace(variavel, snippet);
            }
        }
        return novoTemplate;
    }

    private Map<TipoVariavel, Set<String>> getVariaveisModelo(String modelo) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        HashMap<TipoVariavel, Set<String>> result = new HashMap<TipoVariavel, Set<String>>();
        result.put(TipoVariavel.PRIMITIVO, this.findRegexOccurrences(REGEX_VARIABLES, modelo));
        result.put(TipoVariavel.TABELA, this.findRegexOccurrences(REGEX_TABLES, modelo));
        stopWatch.stop();
        log.info("Tempo leitura vari\u00e1veis: {}s", (Object)stopWatch.getTotalTimeSeconds());
        return result;
    }

    private List<SqlModelo> getSqlModelos(ModeloDados modeloDados) {
        List variaveis = this.variavelSqlModeloRepository.findAllByModeloId(modeloDados.getId());
        return variaveis.stream().map(VariavelSqlModelo::getSqlModelo).collect(Collectors.toList());
    }

    private br.com.elotech.protocolo.dto.ModeloDadosResultDTO loadDataFromSql(ModeloParamsDTO params) {
        br.com.elotech.protocolo.dto.ModeloDadosResultDTO result = new br.com.elotech.protocolo.dto.ModeloDadosResultDTO();
        List sqls = this.getSqlModelos(params.getModeloDados());
        for (SqlModelo sql : sqls) {
            String scriptSql = new String(sql.getScript().getBytes(), Charset.defaultCharset());
            HashMap paramsMap = new HashMap();
            Boolean containsSqlKey = params.getParamValues().stream().anyMatch(map -> map.containsKey(sql.getIdentificador()));
            if (Boolean.TRUE.equals(containsSqlKey)) {
                List<Map> sqlParams = params.getParamValues().stream().map(stringMap -> (Map)stringMap.get(sql.getIdentificador())).filter(Objects::nonNull).collect(Collectors.toList());
                sqlParams.forEach(paramsMap::putAll);
            }
            SqlRowSet sqlResults = this.jdbcTemplate.queryForRowSet(scriptSql, paramsMap);
            Stream<String> columnNames = Stream.of(sqlResults.getMetaData().getColumnNames());
            result.getMetadata().put(sql.getIdentificador(), columnNames.map(column -> {
                MetaModelField field = new MetaModelField();
                field.setFieldName(column.toUpperCase());
                field.setCaption(column);
                return field;
            }).collect(Collectors.toList()));
            ArrayList arrayMaps = new ArrayList();
            while (sqlResults.next()) {
                LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
                for (MetaModelField metaModelField : (List)result.getMetadata().get(sql.getIdentificador())) {
                    String value = sqlResults.getString(metaModelField.getFieldName());
                    values.put(metaModelField.getFieldName().toUpperCase(), value);
                }
                arrayMaps.add(values);
            }
            result.getData().put(sql.getIdentificador(), arrayMaps);
        }
        return result;
    }

    private Set<String> findRegexOccurrences(String regex, String content) {
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = Pattern.compile(regex).matcher(content);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    private ITemplateEngine createTemplateEngine() {
        StringTemplateResolver templateResolver = new StringTemplateResolver();
        templateResolver.setTemplateMode(TemplateMode.HTML);
        SpringTemplateEngine engine = new SpringTemplateEngine();
        engine.setTemplateResolver((ITemplateResolver)templateResolver);
        return engine;
    }

    public ModeloDados findOne(Long id) {
        ModeloDados modelo = (ModeloDados)this.getRepository().findById((Object)id).orElseThrow(() -> new RegistroNaoEncontradoException(ModeloDados.class));
        List modeloDadosArquivos = this.modeloDadosArquivoRepository.findAllByModeloId(modelo.getId()).stream().sorted(Comparator.comparing(ModeloDadosArquivo::getDataCriacao).reversed()).collect(Collectors.toList());
        if (!modeloDadosArquivos.isEmpty()) {
            ModeloDadosArquivo modeloDadosArquivo = (ModeloDadosArquivo)modeloDadosArquivos.stream().findFirst().get();
            Optional arquivoContentByEntityArquivo = this.arquivoService.downloadArquivo(modeloDadosArquivo.getIdArquivo());
            if (arquivoContentByEntityArquivo.isEmpty()) {
                throw new EloValidationException("N\u00e3o foi poss\u00edvel processar o modelo. Motivo: Arquivo n\u00e3o encontrado.");
            }
            modelo.setTemplateHtml(new String(((EloArquivoDTO)arquivoContentByEntityArquivo.get()).getContent().getBinary(), Charset.defaultCharset()));
            modelo.setArquivoNome(((EloArquivoDTO)arquivoContentByEntityArquivo.get()).getNome());
            modelo.setArquivoIdentificador(modeloDadosArquivo.getIdentificador());
            modelo.setArquivoFullPath(this.arquivoService.getFullPath(modeloDadosArquivo.getIdArquivo()));
        }
        return modelo;
    }

    @Transactional
    public ModeloDados saveOrUpdate(ModeloDados modeloDados, Authentication auth) {
        modeloDados.setEntidade(RequestHeaderHelper.getEntidadeLogada());
        modeloDados.setExercicio(Long.valueOf(ContextHolder.getHeaderValueExercicio().intValue()));
        modeloDados.getAssuntos().forEach(ma -> ma.setModelo(modeloDados));
        modeloDados.getSqls().forEach(sql -> sql.setModelo(modeloDados));
        ModeloDados modeloSaved = (ModeloDados)this.getRepository().saveAndFlush((Object)modeloDados);
        if (!StringUtils.isEmpty((Object)modeloDados.getTemplateHtml())) {
            ByteMultipartFile byteMultipartFile = new ByteMultipartFile(modeloDados.getTemplateHtml().getBytes(StandardCharsets.UTF_8), "text/html", modeloSaved.getNome());
            Long idArquivo = this.arquivoService.addArquivo((MultipartFile)byteMultipartFile).getId();
            this.saveNewModeloDadosArquivo(modeloSaved, idArquivo, auth.getName());
        }
        return modeloSaved;
    }

    @Transactional
    public void delete(Long id) {
        ModeloDados modeloDados = (ModeloDados)this.getRepository().findById((Object)id).orElseThrow(() -> new RegistroNaoEncontradoException(ModeloDados.class));
        List modeloDadosArquivos = this.modeloDadosArquivoRepository.findAllByModeloId(modeloDados.getId());
        this.modeloDadosArquivoRepository.deleteAll((Iterable)modeloDadosArquivos);
        this.getRepository().delete((Object)modeloDados);
    }

    private void saveNewModeloDadosArquivo(ModeloDados modeloSaved, Long idArquivo, String userAuth) {
        List modeloDadosArquivos = this.modeloDadosArquivoRepository.findAllByModeloId(modeloSaved.getId());
        this.modeloDadosArquivoRepository.deleteAll((Iterable)modeloDadosArquivos);
        ModeloDadosArquivo modeloDadosArquivo = new ModeloDadosArquivo();
        modeloDadosArquivo.setIdArquivo(idArquivo);
        modeloDadosArquivo.setDescricao(modeloSaved.getNome());
        modeloDadosArquivo.setNome(modeloSaved.getNome());
        modeloDadosArquivo.setUsuario(userAuth);
        modeloDadosArquivo.setIdentificador(UUID.randomUUID().toString());
        modeloDadosArquivo.setModelo(modeloSaved);
        this.modeloDadosArquivoRepository.save((Object)modeloDadosArquivo);
    }

    @Transactional
    public ModeloDados clone(Long id, String nomeModelo) {
        ModeloDados novoModeloDados = new ModeloDados();
        ModeloDados origemModeloDados = (ModeloDados)this.getRepository().findById((Object)id).orElseThrow(() -> new RegistroNaoEncontradoException(ModeloDados.class));
        BeanUtils.copyProperties((Object)origemModeloDados, (Object)novoModeloDados, (String[])new String[]{"id", "nome", "sqls", "assuntos"});
        List assuntos = origemModeloDados.getAssuntos().stream().map(origemAssunto -> {
            ModeloAssunto novoAssunto = new ModeloAssunto();
            BeanUtils.copyProperties((Object)origemAssunto, (Object)novoAssunto, (String[])new String[]{"id", "modelo"});
            novoAssunto.setModelo(novoModeloDados);
            return novoAssunto;
        }).collect(Collectors.toList());
        List sqls = origemModeloDados.getSqls().stream().map(origemSql -> {
            VariavelSqlModelo novoSql = new VariavelSqlModelo();
            BeanUtils.copyProperties((Object)origemSql, (Object)novoSql, (String[])new String[]{"id", "modelo"});
            novoSql.setModelo(novoModeloDados);
            return novoSql;
        }).collect(Collectors.toList());
        novoModeloDados.setNome(nomeModelo);
        novoModeloDados.getAssuntos().addAll(assuntos);
        novoModeloDados.getSqls().addAll(sqls);
        this.getRepository().saveAndFlush((Object)novoModeloDados);
        List arquivos = this.modeloDadosArquivoRepository.findAllByModeloId(id).stream().sorted(Comparator.comparing(ModeloDadosArquivo::getDataCriacao).reversed()).collect(Collectors.toList());
        EloArquivoDTO arquivoContentByEntityArquivo = (EloArquivoDTO)this.arquivoService.downloadArquivo(((ModeloDadosArquivo)arquivos.get(0)).getIdArquivo()).orElseThrow(() -> new RegistroNaoEncontradoException(EloArquivoDTO.class));
        String htmlModelo = new String(arquivoContentByEntityArquivo.getContent().getBinary(), Charset.defaultCharset());
        ByteMultipartFile byteMultipartFile = new ByteMultipartFile(htmlModelo.getBytes(StandardCharsets.UTF_8), "text/html", nomeModelo);
        Long idArquivo = this.arquivoService.addArquivo((MultipartFile)byteMultipartFile).getId();
        String userAuth = SecurityContextHolder.getContext().getAuthentication().getName();
        this.saveNewModeloDadosArquivo(novoModeloDados, idArquivo, userAuth);
        return novoModeloDados;
    }

    public String findTemplate(Long id) {
        Optional arquivoDTO;
        Optional modeloDadosArquivo = this.modeloDadosArquivoRepository.findAllByModeloId(id).stream().sorted(Comparator.comparing(ModeloDadosArquivo::getDataCriacao).reversed()).collect(Collectors.toList()).stream().findFirst();
        if (modeloDadosArquivo.isPresent() && (arquivoDTO = this.arquivoService.downloadArquivo(((ModeloDadosArquivo)modeloDadosArquivo.get()).getIdArquivo())).isPresent()) {
            return new String(((EloArquivoDTO)arquivoDTO.get()).getContent().getBinary(), Charset.defaultCharset());
        }
        return "";
    }

    @Transactional
    public void saveArquivo(Long modeloDadosId, MultipartFile arquivo, Authentication auth) {
        ModeloDados modeloDados = (ModeloDados)this.getRepository().findOne((Object)modeloDadosId);
        if (TipoModeloEnum.OFFICE.equals((Object)modeloDados.getTipo()) && !MimeTypeEnum.DOCX.getType().equals(arquivo.getContentType()) && !MimeTypeEnum.ODT.getType().equals(arquivo.getContentType())) {
            throw new CriacaoNaoPermitidaException("Para arquivos do tipo office, \u00e9 permitido apenas o upload de arquivos .docx e .odt");
        }
        Long arquivoId = this.arquivoService.addArquivo(arquivo).getId();
        this.saveNewModeloDadosArquivo(modeloDados, arquivoId, auth.getName());
    }

    public OfficeDTO processarModeloDadosOffice(ModeloParamsDTO params) {
        br.com.elotech.protocolo.dto.ModeloDadosResultDTO variaveis = this.loadDataFromSql(params);
        ModeloDadosResultDTO variaveisAdm = new ModeloDadosResultDTO(variaveis.getData(), variaveis.getMetadata(), new HashMap(), new HashMap());
        ModeloDadosArquivo modeloDadosArquivo = (ModeloDadosArquivo)this.modeloDadosArquivoRepository.findAllByModeloId(params.getModeloDados().getId()).stream().findFirst().orElseThrow(() -> new RegistroNaoEncontradoException("Arquivo n\u00e3o encontrado!"));
        Optional arquivo = this.arquivoService.downloadArquivo(modeloDadosArquivo.getIdArquivo());
        EloArquivoContentDTO content = arquivo.orElse(new EloArquivoDTO()).getContent();
        if (MimeTypeEnum.ODT.getType().equals(content.getMimeType())) {
            return new LibreOfficeUtils().generate(variaveisAdm, content.getBinary());
        }
        return new WordOfficeUtils().generate(variaveisAdm, content.getBinary());
    }
}

