/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.mail.MailConfigParamsService;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.exception.ParameterNotFoundException;
import br.com.elotech.protocolo.service.ParametroService;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!dev && !test"})
public class MailConfigurationParamsProtocolo
implements MailConfigParamsService {
    private final ParametroService parametroService;

    public MailConfigurationParamsProtocolo(ParametroService parametroService) {
        this.parametroService = parametroService;
    }

    public String getHost() {
        return this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_SERVIDOR_SMTP.getCodigo());
    }

    public int getPort() {
        Long porta = this.parametroService.getParamValueAsLong(ParametroEnum.EMAIL_PORTA_SMTP.getCodigo());
        if (porta == null) {
            throw new ParameterNotFoundException("Par\u00e2metro 71 e-mail porta SMTP n\u00e3o configurado");
        }
        return porta.intValue();
    }

    public String getFrom() {
        return this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_REMETENTE_PADRAO.getCodigo());
    }

    public String getUserName() {
        return this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_USUARIO_SMTP.getCodigo());
    }

    public String getPassword() {
        return this.parametroService.getParamValueAsString(ParametroEnum.EMAIL_SENHA_SMTP.getCodigo());
    }

    public Boolean isSTARTTLS() {
        return this.parametroService.getParamValueAsBoolean(ParametroEnum.UTILIZA_STARTTLS.getCodigo());
    }

    public Boolean isSSL() {
        return this.parametroService.getParamValueAsBoolean(ParametroEnum.UTILIZA_SSL.getCodigo());
    }
}

