/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.protocolo.domain.Usuario;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;

@Service
public class Mail {
    private final MailService mailService;
    private final Logger log = LoggerFactory.getLogger(Mail.class);
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private SpringTemplateEngine templateEngine;

    @Autowired
    public Mail(MailService mailService) {
        this.mailService = mailService;
    }

    @Async
    public void sendActivationEmail(Usuario user, String baseUrl) {
        this.log.debug("Sending activation e-mail to '{}'", (Object)user.getEmail());
        Locale locale = Locale.getDefault();
        Context context = new Context(locale);
        context.setVariable("user", (Object)user);
        context.setVariable("baseUrl", (Object)baseUrl);
        String content = this.templateEngine.process("activationEmail", (IContext)context);
        String subject = this.messageSource.getMessage("email.activation.title", null, locale);
        this.mailService.sendEmail(MailParams.builder().to(user.getEmail()).subject(subject).content(content).multipart(false).html(true).build());
    }

    @Async
    public void sendCreationEmail(Usuario user, String baseUrl) {
        this.log.debug("Sending creation e-mail to '{}'", (Object)user.getEmail());
        Locale locale = Locale.getDefault();
        Context context = new Context(locale);
        context.setVariable("user", (Object)user);
        context.setVariable("baseUrl", (Object)baseUrl);
        String content = this.templateEngine.process("creationEmail", (IContext)context);
        String subject = this.messageSource.getMessage("email.activation.title", null, locale);
        this.mailService.sendEmail(MailParams.builder().to(user.getEmail()).subject(subject).content(content).multipart(false).html(true).build());
    }

    @Async
    public void sendPasswordResetMail(Usuario user, String baseUrl) {
        this.log.debug("Sending password reset e-mail to '{}'", (Object)user.getEmail());
        Locale locale = Locale.getDefault();
        Context context = new Context(locale);
        context.setVariable("user", (Object)user);
        context.setVariable("baseUrl", (Object)baseUrl);
        String content = this.templateEngine.process("passwordResetEmail", (IContext)context);
        String subject = this.messageSource.getMessage("email.reset.title", null, locale);
        this.mailService.sendEmail(MailParams.builder().to(user.getEmail()).subject(subject).content(content).multipart(false).html(true).build());
    }
}

