/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.DuplicateRecordException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.Cidade;
import br.com.elotech.protocolo.domain.Logradouro;
import br.com.elotech.protocolo.domain.TipoLogradouro;
import br.com.elotech.protocolo.repository.LogradouroRepository;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class LogradouroService
extends CrudService<Logradouro, Long> {
    public LogradouroRepository getRepository() {
        return (LogradouroRepository)super.getRepository();
    }

    protected void beforeInsert(Logradouro logradouro) {
        List lstLogradouroDuplicado = this.getRepository().findByDescricaoIgnoreCaseAndCidadeAndTipoLogradouro(logradouro.getDescricao(), logradouro.getCidade(), logradouro.getTipoLogradouro());
        if (!lstLogradouroDuplicado.isEmpty()) {
            throw new DuplicateRecordException(String.format("Logradouro %s da cidade %s e tipo logradouro %s j\u00e1 cadastrada.", logradouro.getDescricao(), logradouro.getCidade().getId(), logradouro.getTipoLogradouro().getId()));
        }
        super.beforeInsert((EloEntity)logradouro);
    }

    public List<Logradouro> findByDescricaoAndCidadeAndTipoLogradouro(String descricao, Cidade cidade, TipoLogradouro tipoLogradouro) {
        return this.getRepository().findByDescricaoIgnoreCaseAndCidadeAndTipoLogradouro(descricao, cidade, tipoLogradouro);
    }

    public List<Logradouro> findByDescricaoAndCidade(String descricao, Cidade cidade) {
        return this.getRepository().findByDescricaoIgnoreCaseAndCidade(descricao, cidade);
    }
}

