/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.LocalPK;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Roteiro;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.interfaces.ILocal;
import br.com.elotech.protocolo.repository.LocalRepository;
import br.com.elotech.protocolo.repository.RoteiroRepository;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.specs.LocalSpecificationHelper;
import br.com.elotech.protocolo.utils.UsuarioUtils;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class LocalService
extends CrudService<Local, LocalPK> {
    private static final Character LIKE_OP = Character.valueOf('%');
    private final LocalRepository localRepository;
    private final EntidadeService entidadeService;
    private final UsuarioService usuarioService;
    private final ParametroService parametroService;
    private final RoteiroRepository roteiroRepository;

    public LocalService(LocalRepository localRepository, EntidadeService entidadeService, UsuarioService usuarioService, ParametroService parametroService, RoteiroRepository roteiroRepository) {
        this.localRepository = localRepository;
        this.entidadeService = entidadeService;
        this.usuarioService = usuarioService;
        this.parametroService = parametroService;
        this.roteiroRepository = roteiroRepository;
    }

    public LocalRepository getRepository() {
        return (LocalRepository)super.getRepository();
    }

    public Page<Local> searchByUsuarioAndDescricao(String userName, String descricao, Long local, Pageable page) {
        Usuario usuarioLogado = this.usuarioService.findUsuarioByName(userName);
        long entidadeId = this.entidadeService.getEntidadeLogada();
        if (usuarioLogado == null) {
            throw new IllegalStateException(String.format("N\u00e3o foi poss\u00edvel encontrar o usu\u00e1rio logado %s", StringUtils.stripToEmpty((String)userName)));
        }
        if (UsuarioUtils.isAlteraTodosProc((Usuario)usuarioLogado, (Long)entidadeId).booleanValue()) {
            Locale locale = LocaleContextHolder.getLocale();
            Specification spec = Specification.where((Specification)LocalSpecificationHelper.byAtivo());
            if (!Strings.isNullOrEmpty((String)descricao)) {
                spec = spec.and(LocalSpecificationHelper.byDescricaoLocalLike((String)(LIKE_OP + descricao.toUpperCase(locale).replace(' ', LIKE_OP.charValue()) + LIKE_OP)));
            }
            if (local != null) {
                spec = spec.and(LocalSpecificationHelper.byIdLocal((Long)local));
            }
            spec = spec.and(LocalSpecificationHelper.byEntidade((Long)entidadeId));
            return this.localRepository.findAll(spec, page);
        }
        return this.localRepository.searchByUsuarioAndDescricao(usuarioLogado.getId(), descricao, local, page, Long.valueOf(entidadeId));
    }

    public List<Local> findByUsuario(String usuario) {
        return this.localRepository.findByUsuario(usuario);
    }

    protected void beforeSave(Local entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        List locais = this.getRepository().findByDescricaoIgnoreCase(entity.getDescricao());
        if (locais.size() > 0 && !((Local)locais.get(0)).getId().equals((Object)entity.getId())) {
            throw new RestException(HttpStatus.BAD_REQUEST, String.format("J\u00e1 existe um local com esta descri\u00e7\u00e3o: %s", ((Local)locais.get(0)).getDescricao()));
        }
        Boolean obrigarResponsavelLocal = this.parametroService.getParamValueAsBoolean(ParametroEnum.OBRIGA_RESPONSAVEL_LOCAL.getCodigo());
        if (obrigarResponsavelLocal.booleanValue() && Objects.isNull(entity.getResponsavel())) {
            throw new RestException(HttpStatus.BAD_REQUEST, "\u00c9 obrigat\u00f3rio informar um respons\u00e1vel ao salvar o local");
        }
    }

    public Local initializeTemplate(Authentication auth) {
        Local localInicial = (Local)super.initializeTemplate(auth);
        localInicial.getId().setEntidade(this.entidadeService.getEntidadeAtual());
        return localInicial;
    }

    public List<Local> findAllByLocalPai(LocalPK localPK) {
        return this.localRepository.findAllByLocalPaiIdAndAtivoIsTrue(localPK);
    }

    public List<Roteiro> getRoteirosByLocalId(LocalPK localPk) {
        return this.roteiroRepository.findAllByLocalId(localPk.getId(), localPk.getEntidade().getId());
    }

    public List<ILocal> findByEntidadeSearch(Long entidade, String search) {
        return this.localRepository.findByEntidadeSearch(entidade, search);
    }
}

