/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.console.client.ConsoleClient;
import br.com.elotech.console.dto.ClienteDTO;
import br.com.elotech.keycloakmultirealm.resolver.KeycloakResolver;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import org.keycloak.representations.AccessTokenResponse;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

@Service
@Profile(value={"cloud"})
public class KeycloakAuthService {
    private final KeycloakResolver keycloakResolver;
    private final ConsoleClient consoleClient;

    public KeycloakAuthService(KeycloakResolver keycloakResolver, ConsoleClient consoleClient) {
        this.keycloakResolver = keycloakResolver;
        this.consoleClient = consoleClient;
    }

    private MultiValueMap<String, String> buildLoginRequestBody(String usuario, String senha) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"username", (Object)usuario);
        body.add((Object)"password", (Object)senha);
        body.add((Object)"grant_type", (Object)"password");
        body.add((Object)"client_id", (Object)this.keycloakResolver.getKeycloakDeployment().getResourceName());
        body.add((Object)"client_secret", (Object)this.getClientSecret());
        return body;
    }

    private String getClientSecret() {
        ClienteDTO clienteDTO = this.consoleClient.findClienteByTenant(TenantContextHolder.getCurrentTenantId());
        return clienteDTO.getMultiRealm() != false ? clienteDTO.getRealmSecret() : this.keycloakResolver.getKeycloakDeployment().getResourceCredentials().get("secret").toString();
    }

    public boolean auth(String usuario, String senha, RestTemplate restTemplate) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap body = this.buildLoginRequestBody(usuario, senha);
        HttpEntity loginRequest = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            restTemplate.postForEntity(this.keycloakResolver.getKeycloakDeployment().getTokenUrl(), (Object)loginRequest, AccessTokenResponse.class, new Object[0]);
            return true;
        }
        catch (HttpClientErrorException | ResourceAccessException ex) {
            return false;
        }
    }
}

