/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.arquivo.domain.DomainEntity;
import br.com.elotech.protocolo.domain.EmailInfo;
import br.com.elotech.protocolo.domain.HistoricoEnvioEmailEntity;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.enums.TipoEnvioEmailEnum;
import br.com.elotech.protocolo.repository.HistoricoEnvioEmailRepository;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.stereotype.Service;

@Service
public interface HistoricoEnvioEmailService<T extends HistoricoEnvioEmailEntity<E>, E> {
    public HistoricoEnvioEmailRepository<T, E> getRepository();

    public T createHistorico(DomainEntity<E> var1, TipoEnvioEmailEnum var2, EmailInfo var3);

    default public T createHistorico(DomainEntity<E> domainEntity, TipoEnvioEmailEnum tipoEnvio, EmailInfo emailInfo, Usuario usuario) {
        HistoricoEnvioEmailEntity historicoEnvioEmail = this.createHistorico(domainEntity, tipoEnvio, emailInfo);
        historicoEnvioEmail.setUsuario(usuario);
        return (T)historicoEnvioEmail;
    }

    default public T createHistorico(DomainEntity<E> domainEntity, TipoEnvioEmailEnum tipoEnvio, EmailInfo emailInfo, Pessoa pessoa) {
        HistoricoEnvioEmailEntity historicoEnvioEmail = this.createHistorico(domainEntity, tipoEnvio, emailInfo);
        historicoEnvioEmail.setPessoa(pessoa);
        return (T)historicoEnvioEmail;
    }

    default public boolean existeAvisoEmail(E domainEntityId, TipoEnvioEmailEnum tipoEnvio) {
        return !this.getRepository().findByDomainEntityIdAndTipoEnvio(domainEntityId, tipoEnvio).isEmpty();
    }

    default public boolean existeAvisoEmailUsuario(E domainEntityId, TipoEnvioEmailEnum tipoEnvio, Usuario usuario) {
        return !this.getRepository().findByDomainEntityIdAndTipoEnvioAndUsuario(domainEntityId, tipoEnvio, usuario).isEmpty();
    }

    default public boolean existeAvisoEmailPessoa(E domainEntityId, TipoEnvioEmailEnum tipoEnvio, Pessoa pessoa) {
        return !this.getRepository().findByDomainEntityIdAndTipoEnvioAndPessoa(domainEntityId, tipoEnvio, pessoa).isEmpty();
    }

    default public T save(T historicoEnvioEmail) {
        return (T)((HistoricoEnvioEmailEntity)this.getRepository().saveAndFlush(historicoEnvioEmail));
    }

    default public List<T> saveAll(List<T> historicoEnviosList) {
        return this.getRepository().saveAllAndFlush(historicoEnviosList);
    }

    default public Optional<T> findById(UUID id) {
        return this.getRepository().findById((Object)id);
    }

    default public void deleteByDomainEntity(E domainEntityId) {
        List historicos = this.getRepository().findByDomainEntityId(domainEntityId);
        if (!historicos.isEmpty()) {
            this.getRepository().deleteAll((Iterable)historicos);
            this.getRepository().flush();
        }
    }
}

