/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.protocolo.converter.HashMapConverter;
import br.com.elotech.protocolo.domain.AssinanteGrupoAssinante;
import br.com.elotech.protocolo.domain.FluxoAssinante;
import br.com.elotech.protocolo.domain.FluxoAssinatura;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.UsuarioAssinanteDTO;
import br.com.elotech.protocolo.enums.TipoFluxoAssinanteEnum;
import br.com.elotech.protocolo.enums.TipoIntegracaoEnum;
import br.com.elotech.protocolo.exception.AssinanteNaoEncontrado;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.exception.VariaveisAssinaturaInvalidasException;
import br.com.elotech.protocolo.repository.FluxoAssinaturaRepository;
import br.com.elotech.protocolo.service.EvalExpression;
import br.com.elotech.protocolo.service.FluxoAssinaturaService;
import br.com.elotech.protocolo.service.UsuarioService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class FluxoAssinaturaService
extends CrudService<FluxoAssinatura, UUID> {
    private final EvalExpression evalExpression;
    private final UsuarioService usuarioService;

    public FluxoAssinaturaService(EvalExpression evalExpression, UsuarioService usuarioService) {
        this.evalExpression = evalExpression;
        this.usuarioService = usuarioService;
    }

    public FluxoAssinaturaRepository getCrudRepository() {
        return (FluxoAssinaturaRepository)super.getCrudRepository();
    }

    protected void beforeSave(FluxoAssinatura fluxoAssinatura, Authentication authentication) {
        long sequencia = 1L;
        for (FluxoAssinante assinante : fluxoAssinatura.getAssinantes()) {
            assinante.setFluxoAssinatura(fluxoAssinatura);
            assinante.setSequencia(Long.valueOf(sequencia++));
        }
    }

    public FluxoAssinatura getFluxoAssinatura(TipoIntegracaoEnum tipoIntegracao, Long entidade) {
        return (FluxoAssinatura)this.getCrudRepository().findFirstByTipoIntegracaoAndEntidadeAndAtivoTrue(tipoIntegracao, entidade).orElseThrow(() -> new RegistroNaoEncontradoException("Fluxo de assinatura n\u00e3o encontrado!"));
    }

    private UsuarioAssinanteDTO getUsuarioCriacao(FluxoAssinante fluxoAssinante, HashMap<String, Object> variaveis) {
        String usuarioCriacao = this.getUsuarioCriacaoFromVariaveis(variaveis);
        return UsuarioAssinanteDTO.of((Usuario)((Usuario)this.usuarioService.findById((Serializable)((Object)usuarioCriacao)).orElseThrow(() -> new RegistroNaoEncontradoException(String.format("N\u00e3o foi poss\u00edvel localizar o usu\u00e1rio de cria\u00e7\u00e3o: %s definido pelo fluxo.", usuarioCriacao)))), (TipoFluxoAssinanteEnum)TipoFluxoAssinanteEnum.CRIADOR, (Long)fluxoAssinante.getSequencia());
    }

    private String getUsuarioCriacaoFromVariaveis(HashMap<String, Object> variaveis) {
        if (Objects.nonNull(variaveis.get("usuarioCriacao")) && !((String)variaveis.get("usuarioCriacao")).isBlank()) {
            return (String)variaveis.get("usuarioCriacao");
        }
        throw new EloValidationException("Vari\u00e1vel usuarioCriacao, n\u00e3o foi enviada pela integra\u00e7\u00e3o ou \u00e9 inv\u00e1lida.");
    }

    private List<UsuarioAssinanteDTO> getusuarioIndividualFixo(FluxoAssinante fluxoAssinante) {
        return List.of(UsuarioAssinanteDTO.of((Usuario)fluxoAssinante.getUsuario(), (TipoFluxoAssinanteEnum)TipoFluxoAssinanteEnum.INDIVIDUAL, (Long)fluxoAssinante.getSequencia()));
    }

    private Long getVariavel(String tipoIntegracao, String variavel, HashMap<String, Object> variaveis, boolean obrigatoria) {
        Long value = null;
        if (Objects.nonNull(variaveis.get(variavel))) {
            value = Long.parseLong(variaveis.get(variavel).toString());
        }
        if (obrigatoria && Objects.isNull(value)) {
            throw new VariaveisAssinaturaInvalidasException(tipoIntegracao, variavel, HashMapConverter.toString(variaveis));
        }
        return value;
    }

    private List<UsuarioAssinanteDTO> getUsuariosGrupo(FluxoAssinante fluxoAssinante, HashMap<String, Object> variaveis) {
        String tipoIntegracao = fluxoAssinante.getFluxoAssinatura().getTipoIntegracao().descricao;
        Long orcUnidadeId = this.getVariavel(tipoIntegracao, "orcUnidadeId", variaveis, fluxoAssinante.getRestringeUnidade().booleanValue());
        Long centroCustoId = this.getVariavel(tipoIntegracao, "centroCustoId", variaveis, fluxoAssinante.getRestringeCentroCusto().booleanValue());
        Predicate<AssinanteGrupoAssinante> predicateOrcUnidade = assinanteGrupoAssinante -> fluxoAssinante.getRestringeUnidade() == false || assinanteGrupoAssinante.getAssinante().getUnidadesOrcamentarias().stream().anyMatch(u -> u.getUnidadeOrcamentaria().getId().equals(orcUnidadeId)) && assinanteGrupoAssinante.getAssinante().getUnidadesOrcamentarias().stream().anyMatch(u -> Objects.isNull(u.getGrupoAssinante()) || u.getGrupoAssinante().getId().equals(fluxoAssinante.getGrupoAssinante().getId()));
        Predicate<AssinanteGrupoAssinante> predicateCentroCusto = assinanteGrupoAssinante -> fluxoAssinante.getRestringeCentroCusto() == false || assinanteGrupoAssinante.getAssinante().getCentrosCustos().stream().anyMatch(c -> c.getCentroCusto().equals(centroCustoId)) && assinanteGrupoAssinante.getAssinante().getCentrosCustos().stream().anyMatch(c -> Objects.isNull(c.getGrupoAssinante()) || c.getGrupoAssinante().getId().equals(fluxoAssinante.getGrupoAssinante().getId()));
        return fluxoAssinante.getGrupoAssinante().getGruposAssinantes().stream().filter(predicateOrcUnidade.and(predicateCentroCusto)).map(assinanteGrupoAssinante -> UsuarioAssinanteDTO.of((Usuario)assinanteGrupoAssinante.getAssinante().getUsuario(), (TipoFluxoAssinanteEnum)TipoFluxoAssinanteEnum.GRUPO, (String)assinanteGrupoAssinante.getGrupoAssinante().getDescricao(), (Long)fluxoAssinante.getSequencia())).collect(Collectors.toList());
    }

    public Optional<FluxoAssinante> getFluxoAssinante(FluxoAssinatura fluxoAssinatura, Long lastFluxoAssinante, HashMap<String, Object> variaveis) {
        Long lastSequencia = Optional.ofNullable(lastFluxoAssinante).orElse(0L);
        Optional<FluxoAssinante> fluxoAssinante = fluxoAssinatura.getAssinantes().stream().filter(a -> a.getSequencia() > lastSequencia).min(Comparator.comparing(FluxoAssinante::getSequencia));
        if (fluxoAssinante.isPresent() && !this.checkCondition(fluxoAssinante.get(), variaveis)) {
            return this.getFluxoAssinante(fluxoAssinatura, fluxoAssinante.get().getSequencia(), variaveis);
        }
        return fluxoAssinante;
    }

    private List<UsuarioAssinanteDTO> getUsuarios(FluxoAssinante fluxoAssinante, HashMap<String, Object> variaveis) {
        ArrayList<UsuarioAssinanteDTO> usuariosAssinantes = new ArrayList<UsuarioAssinanteDTO>();
        switch (1.$SwitchMap$br$com$elotech$protocolo$enums$TipoFluxoAssinanteEnum[fluxoAssinante.getTipoFluxoAssinante().ordinal()]) {
            case 1: {
                return this.getusuarioIndividualFixo(fluxoAssinante);
            }
            case 2: {
                return List.of(this.getUsuarioCriacao(fluxoAssinante, variaveis));
            }
            case 3: {
                return this.getUsuariosGrupo(fluxoAssinante, variaveis);
            }
        }
        return usuariosAssinantes;
    }

    public List<UsuarioAssinanteDTO> getUsuarioAssinantesDTO(Long ultimaSequenciaGerada, FluxoAssinatura fluxoAssinatura, HashMap<String, Object> variaveis) {
        List<Object> usuarioAssinantes = new ArrayList<UsuarioAssinanteDTO>();
        Optional fluxoAssinante = this.getFluxoAssinante(fluxoAssinatura, ultimaSequenciaGerada, variaveis);
        if (fluxoAssinante.isEmpty()) {
            return usuarioAssinantes;
        }
        usuarioAssinantes = this.getUsuarios((FluxoAssinante)fluxoAssinante.orElseThrow(), variaveis);
        if (usuarioAssinantes.isEmpty()) {
            throw new AssinanteNaoEncontrado(((FluxoAssinante)fluxoAssinante.get()).getDescricao(), HashMapConverter.toString(variaveis));
        }
        return usuarioAssinantes;
    }

    public boolean checkCondition(FluxoAssinante fluxoAssinante, HashMap<String, Object> variaveis) {
        if (Objects.isNull(fluxoAssinante.getCondicao()) || fluxoAssinante.getCondicao().isBlank()) {
            return true;
        }
        this.evalExpression.clearAllVariables();
        this.evalExpression.addVariables(variaveis);
        return this.evalExpression.testCondition(fluxoAssinante.getCondicao());
    }

    public Optional<String> defaultSearchFilter() {
        return Optional.of("entidade==".concat(ContextHolder.getHeaderValueEntidade().toString()));
    }
}

