/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.MissingConfigurationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Exercicio;
import br.com.elotech.protocolo.domain.ExercicioPK;
import br.com.elotech.protocolo.repository.ExercicioRepository;
import java.time.LocalDate;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ExercicioService
extends ReadOnlyService<Exercicio, ExercicioPK> {
    private static final String EXERCICIO_NAO_CONFIGURADO = "N\u00e3o foi poss\u00edvel encontrar nenhum exerc\u00edcio para a entidade %s";
    private final ExercicioRepository exercicioRepository;

    public ExercicioService(ExercicioRepository exercicioRepository) {
        this.exercicioRepository = exercicioRepository;
    }

    public Long getExercicioAtual() {
        long exercicio = ContextHolder.getHeaderValueExercicio().intValue();
        if (exercicio == 0L) {
            return LocalDate.now().getYear();
        }
        return exercicio;
    }

    public Exercicio getExercicioPadraoEntidade(Entidade entidade) {
        return (Exercicio)this.exercicioRepository.findByIdEntidadeAndAbertoOrderByIdExercicioDesc(entidade, Boolean.TRUE).stream().findFirst().orElseThrow(() -> new MissingConfigurationException(String.format(EXERCICIO_NAO_CONFIGURADO, entidade)));
    }

    public List<Exercicio> findByEntidade(Entidade entidade) {
        return this.exercicioRepository.findByIdEntidadeAndAbertoOrderByIdExercicioDesc(entidade, Boolean.TRUE);
    }
}

