/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.protocolo.exception.CommandExpressionNotAllowedException;
import br.com.elotech.protocolo.service.EvalExpression;
import java.util.HashMap;
import java.util.Objects;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EvalExpressionImpl
implements EvalExpression {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EvalExpressionImpl.class);
    private final ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private ScriptEngine scriptEngine;

    public EvalExpressionImpl() {
        this.initScriptEngine();
    }

    private void initScriptEngine() {
        this.scriptEngine = Objects.requireNonNull(this.scriptEngineManager.getEngineByName("Graal.js"), "N\u00e3o foi poss\u00edvel obter o motor JavaScript");
    }

    public boolean testCondition(String booleanExpression) {
        try {
            return (Boolean)this.scriptEngine.eval(this.checkAllowCommands(booleanExpression));
        }
        catch (ScriptException e) {
            log.warn("Express\u00e3o Inv\u00e1lida.".concat(e.getMessage()));
            log.warn("Express\u00e3o:".concat(booleanExpression));
            throw new EloValidationException("Express\u00e3o Inv\u00e1lida.".concat(e.getMessage()));
        }
    }

    public void addVariable(String name, Object value) {
        this.scriptEngine.put(name, value);
    }

    public void addVariables(HashMap<String, Object> variables) {
        variables.forEach(this.scriptEngine::put);
    }

    public void clearAllVariables() {
        this.initScriptEngine();
    }

    private String checkAllowCommands(String expression) {
        String blockCommands = "for while => function .map foreach .reduce eval( ...";
        for (String command : "for while => function .map foreach .reduce eval( ...".split(" ")) {
            if (!expression.toLowerCase().contains(command)) continue;
            throw new CommandExpressionNotAllowedException(String.format("Por quest\u00f5es de seguran\u00e7a, alguns commandos como: %s, n\u00e3o s\u00e3o permitidos.", command));
        }
        return expression;
    }
}

