/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.DatasetRecord;
import br.com.elotech.fluent.dataset.SimpleDataset;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.protocolo.domain.EstatisticasProcessoGrupo;
import br.com.elotech.protocolo.domain.EstatisticasReport;
import br.com.elotech.protocolo.dto.ProcessoContagemMesAnoDTO;
import br.com.elotech.protocolo.report.datasetrecord.ProcessoContagemMesAnoDatasetRecord;
import br.com.elotech.protocolo.report.loader.CabecalhoParamLoader;
import br.com.elotech.protocolo.service.AgrupamentoAnualProcessoService;
import br.com.elotech.protocolo.service.ProcessoService;
import br.com.elotech.protocolo.web.controller.params.RelatorioContagemMesAnoParams;
import br.com.elotech.protocolo.web.controller.params.RelatorioEstatisticasProcessoParams;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class EstatisticasReportService {
    public static final String ESTATISTICA_REPORT = "estatisticas-protocolo.jrxml";
    private static final Locale BR_LOCALE = new Locale("pt", "BR");
    private final CabecalhoParamLoader cabecalhoLoader;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private final ProcessoService processoService;
    private final AgrupamentoAnualProcessoService agrupamentoAnualProcessoService;
    private final ObjectMapper objectMapper;

    public byte[] impressaoEstatisticas(RelatorioEstatisticasProcessoParams params) {
        EstatisticasReport relatorio = new EstatisticasReport();
        relatorio.setAnoUm(params.getAnoUm());
        relatorio.setAnoDois(params.getAnoDois());
        relatorio.setEstatisticas(this.generateEstatisticasProcessoGrupo((RelatorioContagemMesAnoParams)params));
        if (params.getImprimeAgrupamento().booleanValue()) {
            relatorio.setAgrupamentos(this.agrupamentoAnualProcessoService.findByAgrupamentoAndEntidadeAndExercicios(params.getTipoAgrupamentoAnualProcesso(), params.getIdEntidade(), params.getAnoUm(), params.getAnoDois()));
        }
        ReportDatasource datasource = ReportDatasource.builder().add("main", () -> SimpleDataset.single((DatasetRecord)relatorio, EstatisticasReport.class)).params((ParamLoader)this.cabecalhoLoader).build();
        return EloReportFactory.jasper().reportFile(this.reportFileResolverFactory.fromFile(ESTATISTICA_REPORT)).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build().exportToPdf();
    }

    public List<EstatisticasProcessoGrupo> generateEstatisticasProcessoGrupo(RelatorioContagemMesAnoParams params) {
        ArrayList<EstatisticasProcessoGrupo> estatisticaList = new ArrayList<EstatisticasProcessoGrupo>();
        ProcessoContagemMesAnoDTO dto = this.processoService.relatorioContagemPorMesEAno(params);
        this.preencheMeses(dto.getAnoUm(), params.getAnoUm().toString(), estatisticaList);
        this.preencheMeses(dto.getAnoDois(), params.getAnoDois().toString(), estatisticaList);
        this.preencheMeses(dto.getArquivadosAnoUm(), "Arquivados ".concat(params.getAnoUm().toString()), estatisticaList);
        this.preencheMeses(dto.getArquivadosAnoDois(), "Arquivados ".concat(params.getAnoDois().toString()), estatisticaList);
        return estatisticaList;
    }

    private void preencheMeses(List<ProcessoContagemMesAnoDatasetRecord> dtoList, String grupo, List<EstatisticasProcessoGrupo> resultList) {
        for (Month month : Month.values()) {
            EstatisticasProcessoGrupo estatistica = new EstatisticasProcessoGrupo();
            estatistica.setMes(StringUtils.capitalize((String)month.getDisplayName(TextStyle.FULL, BR_LOCALE)));
            estatistica.setGrupo(grupo);
            estatistica.setProcessos(NumberUtils.LONG_ZERO);
            dtoList.stream().filter(item -> item.getMes().equals(month.getValue())).findFirst().ifPresent(value -> estatistica.setProcessos(value.getProcessos()));
            resultList.add(estatistica);
        }
    }

    @Generated
    public EstatisticasReportService(CabecalhoParamLoader cabecalhoLoader, ReportFileResolverFactory reportFileResolverFactory, ProcessoService processoService, AgrupamentoAnualProcessoService agrupamentoAnualProcessoService, ObjectMapper objectMapper) {
        this.cabecalhoLoader = cabecalhoLoader;
        this.reportFileResolverFactory = reportFileResolverFactory;
        this.processoService = processoService;
        this.agrupamentoAnualProcessoService = agrupamentoAnualProcessoService;
        this.objectMapper = objectMapper;
    }
}

