/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.service.EntidadeLogadaService;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.UsuarioEntidade;
import br.com.elotech.protocolo.repository.EntidadeRepository;
import br.com.elotech.protocolo.service.UsuarioService;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class EntidadeService
extends ReadOnlyService<Entidade, Long>
implements EntidadeLogadaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntidadeService.class);
    private final EntidadeRepository repository;
    private final UsuarioService usuarioService;

    public EntidadeService(EntidadeRepository repository, UsuarioService usuarioService) {
        this.repository = repository;
        this.usuarioService = usuarioService;
    }

    public Entidade getEntidadeAtual() {
        Entidade entidade = this.findByIdOrEntidadePrincipal(Long.valueOf(ContextHolder.getHeaderValueEntidade().intValue()));
        log.trace("Entidade atual = {}", (Object)entidade);
        return entidade;
    }

    public Long getEntidadeLogada() {
        return this.getEntidadeAtual().getId();
    }

    public Entidade getEntidadePrincipalUsuario(String name) {
        log.debug("Obtendo entidade principal do usu\u00e1rio {}", (Object)name);
        List entidades = this.usuarioService.findEntidadesByUsername(name);
        Optional<UsuarioEntidade> entidadePadrao = entidades.stream().filter(entidade -> Boolean.TRUE.equals(entidade.getPadrao())).findFirst();
        if (entidadePadrao.isEmpty()) {
            log.debug("Usu\u00e1rio {} n\u00e3o possui entidade principal, obtendo entidade principal geral", (Object)name);
            return this.repository.findEntidadePrincipal();
        }
        Long entidadeId = entidadePadrao.get().getId().getEntidade().getId();
        log.debug("Obtida a entidade principal do usu\u00e1rio {} que \u00e9 {}", (Object)name, (Object)entidadeId);
        return (Entidade)this.repository.findOne((Object)entidadeId);
    }

    public Entidade findByIdOrEntidadePrincipal(Long id) {
        log.trace("Obtendo entidade pelo id {} ou Principal", (Object)id);
        return Optional.ofNullable((Entidade)this.repository.findOne((Object)id)).orElseGet(() -> {
            log.debug("Entidade com id {} n\u00e3o encontrada, obtendo entidade do usu\u00e1rio logado", (Object)id);
            return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(usuarioLogado -> this.getEntidadePrincipalUsuario(usuarioLogado.getName())).orElseGet(() -> {
                log.debug("Usu\u00e1rio n\u00e3o logado, obtendo entidade principal geral");
                return this.repository.findEntidadePrincipal();
            });
        });
    }
}

