/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.console.client.UsuarioClient;
import br.com.elotech.console.dto.EntidadeDTO;
import br.com.elotech.console.dto.UsuarioEntidadeDTO;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.repository.EntidadeRepository;
import br.com.elotech.protocolo.service.UsuarioCloudService;
import java.util.Objects;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"cloud"})
public class EntidadeCloudService {
    private final EntidadeRepository entidadeRepository;
    private final UsuarioCloudService usuarioCloudService;
    private final UsuarioClient usuarioClient;

    public EntidadeCloudService(EntidadeRepository entidadeRepository, UsuarioCloudService usuarioCloudService, UsuarioClient usuarioClient) {
        this.entidadeRepository = entidadeRepository;
        this.usuarioCloudService = usuarioCloudService;
        this.usuarioClient = usuarioClient;
    }

    public Entidade getEntidadePrincipalUsuarioKeycloak() {
        String usuarioId = this.usuarioCloudService.getUsuarioLogado().getId().toString();
        Optional<UsuarioEntidadeDTO> entidadePadrao = this.usuarioClient.findAllEntidadesByUsuario(usuarioId).stream().filter(entidade -> Boolean.TRUE.equals(entidade.getPadrao())).findFirst();
        if (entidadePadrao.isPresent() && Objects.nonNull(entidadePadrao.get().getEntidade().getCodigo())) {
            EntidadeDTO dto = entidadePadrao.get().getEntidade();
            Entidade entidade2 = new Entidade();
            entidade2.setId(dto.getCodigo());
            entidade2.setEntidadeConsole(dto.getId());
            entidade2.setNome(dto.getNome());
            entidade2.setCnpj(dto.getCnpj());
            return entidade2;
        }
        return this.entidadeRepository.findEntidadePrincipal();
    }
}

