/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.Documento;
import br.com.elotech.protocolo.repository.DocumentoRepository;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class DocumentoService
extends CrudService<Documento, Long> {
    public DocumentoRepository getRepository() {
        return (DocumentoRepository)super.getRepository();
    }

    protected void beforeSave(Documento entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        List documentos = this.getRepository().findByDescricaoIgnoreCase(entity.getDescricao());
        if (documentos.size() > 0 && !((Documento)documentos.get(0)).getId().equals(entity.getId())) {
            throw new RestException(HttpStatus.BAD_REQUEST, String.format("J\u00e1 existe um documento com esta descri\u00e7\u00e3o: %s", ((Documento)documentos.get(0)).getDescricao()));
        }
    }

    public Documento findDocumentoArquivo(Long documentoId) {
        if (documentoId != null) {
            return (Documento)this.getRepository().findOne((Object)documentoId);
        }
        return null;
    }
}

