/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.DataIgnorada;
import br.com.elotech.protocolo.domain.TipoAndamento;
import br.com.elotech.protocolo.repository.DataIgnoradaRepository;
import br.com.elotech.protocolo.repository.TipoAndamentoRepository;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class DataIgnoradaService
extends CrudService<DataIgnorada, Long> {
    private final DataIgnoradaRepository dataIgnoradaRepository;
    private final TipoAndamentoRepository tipoAndamentoRepository;
    private static final Map<DayOfWeek, String> DIAS_DA_SEMANA = new HashMap();

    public DataIgnoradaService(DataIgnoradaRepository dataIgnoradaRepository, TipoAndamentoRepository tipoAndamentoRepository) {
        this.dataIgnoradaRepository = dataIgnoradaRepository;
        this.tipoAndamentoRepository = tipoAndamentoRepository;
    }

    public List<DataIgnorada> saveDataRange(DataIgnorada dataIgnorada) {
        ArrayList<DataIgnorada> datasGeradas = new ArrayList<DataIgnorada>();
        if (dataIgnorada.getData().isBefore(dataIgnorada.getDataFinal())) {
            LocalDate dataInicial = dataIgnorada.getData();
            while (!dataInicial.isAfter(dataIgnorada.getDataFinal())) {
                DataIgnorada dataGerada = new DataIgnorada();
                dataGerada.setDescricao(dataIgnorada.getDescricao());
                dataGerada.setData(dataInicial);
                dataGerada.setFeriado(dataIgnorada.getFeriado());
                datasGeradas.add((DataIgnorada)this.dataIgnoradaRepository.saveAndFlush((Object)this.validaData(dataGerada)));
                dataInicial = dataInicial.plusDays(1L);
            }
        } else {
            datasGeradas.add((DataIgnorada)this.dataIgnoradaRepository.saveAndFlush((Object)this.validaData(dataIgnorada)));
        }
        return datasGeradas;
    }

    protected void beforeSave(DataIgnorada entity, Authentication authentication) {
        super.beforeSave((EloEntity)this.validaData(entity), authentication);
    }

    public LocalDate sugereData(Long id, LocalDate data) {
        LocalDate dataCalculada = data;
        int diaSemana = dataCalculada.getDayOfWeek().getValue();
        TipoAndamento tipoAndamento = (TipoAndamento)this.tipoAndamentoRepository.findOne((Object)id);
        boolean isTipoProxDiaUtilSabado = tipoAndamento.getPrazoFinalizadoProximoDiaUtilSabado();
        boolean isTipoProxDiaUtilDomingo = tipoAndamento.getPrazoFinalizadoProximoDiaUtilDomingo();
        while (this.dataIgnoradaRepository.existsByData(dataCalculada) || diaSemana == 6 && isTipoProxDiaUtilSabado || diaSemana == 7 && isTipoProxDiaUtilDomingo) {
            dataCalculada = dataCalculada.plusDays(diaSemana == 6 ? 2L : 1L);
            diaSemana = dataCalculada.getDayOfWeek().getValue();
        }
        return dataCalculada;
    }

    private DataIgnorada validaData(DataIgnorada dataIgnorada) {
        dataIgnorada.setAno(Long.valueOf(dataIgnorada.getData().getYear()));
        dataIgnorada.setDiaSemana(DIAS_DA_SEMANA.getOrDefault(dataIgnorada.getData().getDayOfWeek(), "Dia da semana inv\u00e1lido"));
        dataIgnorada.setFimSemana(Boolean.valueOf(dataIgnorada.getData().getDayOfWeek().getValue() > 5));
        if (Boolean.TRUE.equals(this.dataIgnoradaRepository.existsByData(dataIgnorada.getData()))) {
            throw new EloValidationException(String.format("A data %s j\u00e1 foi cadastrada.", dataIgnorada.getData().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"))));
        }
        return dataIgnorada;
    }

    static {
        DIAS_DA_SEMANA.put(DayOfWeek.MONDAY, "Segunda");
        DIAS_DA_SEMANA.put(DayOfWeek.TUESDAY, "Ter\u00e7a");
        DIAS_DA_SEMANA.put(DayOfWeek.WEDNESDAY, "Quarta");
        DIAS_DA_SEMANA.put(DayOfWeek.THURSDAY, "Quinta");
        DIAS_DA_SEMANA.put(DayOfWeek.FRIDAY, "Sexta");
        DIAS_DA_SEMANA.put(DayOfWeek.SATURDAY, "S\u00e1bado");
        DIAS_DA_SEMANA.put(DayOfWeek.SUNDAY, "Domingo");
    }
}

