/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.CorrecaoFluxo;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.repository.CorrecaoFluxoRepository;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.service.HistoricoTramiteEmailService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.utils.UsuarioUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CorrecaoFluxoService
extends CrudService<CorrecaoFluxo, Long> {
    private static final String PROCESSO_SEM_ULTIMO_TRAMITE = "N\u00e3o foi poss\u00edvel encontrar o \u00faltimo tr\u00e2mite do processo";
    private static final int NUMERO_MINIMO_TRAMITES = 2;
    private static final String SIM = "S";
    private final UsuarioService usuarioService;
    private final CorrecaoFluxoRepository correcaoFluxoRepository;
    private final ParametroService parametroService;
    private final ProcessoRepository processoRepository;
    private final HistoricoTramiteEmailService historicoTramiteEmailService;

    public CorrecaoFluxoService(UsuarioService usuarioService, CorrecaoFluxoRepository correcaoFluxoRepository, ParametroService parametroService, ProcessoRepository processoRepository, HistoricoTramiteEmailService historicoTramiteEmailService) {
        this.usuarioService = usuarioService;
        this.correcaoFluxoRepository = correcaoFluxoRepository;
        this.parametroService = parametroService;
        this.processoRepository = processoRepository;
        this.historicoTramiteEmailService = historicoTramiteEmailService;
    }

    private List<Local> getLocaisUsuario(Usuario usuario) {
        return this.usuarioService.listarLocaisUsuario(usuario).stream().map(ul -> ul.getId().getLocal()).collect(Collectors.toList());
    }

    @Transactional
    public Processo geraCorrecaoFluxo(Processo processo, String username, String justificativa) {
        if (processo.getTramites().size() == 2) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel excluir os tramites iniciais do processo.");
        }
        if (!this.possuiPermissaoExclusaoTramite(processo, username)) {
            throw new EloValidationException(String.format("Usu\u00e1rio  \"%s\" n\u00e3o possui permiss\u00e3o para excluir o \u00faltimo tr\u00e2mite, devido as suas permiss\u00f5es de locais.", username));
        }
        this.saveCorrecaoFluxo(processo, username, justificativa);
        return this.removerUltimoTramite(processo);
    }

    private Processo removerUltimoTramite(Processo processo) {
        Tramite ultimoTramite = (Tramite)processo.getUltimoTramite().orElseThrow(() -> new IllegalStateException(PROCESSO_SEM_ULTIMO_TRAMITE));
        this.historicoTramiteEmailService.deleteByDomainEntity((Object)ultimoTramite.getId());
        processo.removerTramite(ultimoTramite);
        Optional ultimoTramiteValido = processo.getUltimoTramite();
        if (ultimoTramiteValido.isPresent()) {
            processo.setLocalAtual(((Tramite)ultimoTramiteValido.get()).getLocal());
            processo.setFuncao(((Tramite)ultimoTramiteValido.get()).getFuncao());
            processo.setSituacao(((Tramite)ultimoTramiteValido.get()).getSituacao());
            processo.setLocalDestino(((Tramite)ultimoTramiteValido.get()).getLocal());
        }
        return (Processo)this.processoRepository.saveAndFlush((Object)processo);
    }

    private void saveCorrecaoFluxo(Processo processo, String username, String justificativa) {
        Tramite ultimoTramite = (Tramite)processo.getUltimoTramite().orElseThrow(() -> new IllegalStateException(PROCESSO_SEM_ULTIMO_TRAMITE));
        CorrecaoFluxo correcaoFluxo = new CorrecaoFluxo();
        correcaoFluxo.setNumero(processo.getId().getNumero());
        correcaoFluxo.setAno(processo.getId().getAno());
        correcaoFluxo.setTipo(processo.getId().getTipo());
        correcaoFluxo.setEntidade(processo.getId().getEntidade());
        correcaoFluxo.setMotivo(justificativa);
        correcaoFluxo.setParecerTramite(ultimoTramite.getParecer());
        correcaoFluxo.setSeqTramite(ultimoTramite.getId().getSequencia());
        correcaoFluxo.setUsuario(username);
        this.correcaoFluxoRepository.saveAndFlush((Object)correcaoFluxo);
    }

    public boolean possuiPermissaoExclusaoTramite(Processo processo, String username) {
        String parametroPermissao = this.parametroService.getParamValueAsString(ParametroEnum.VERIFICA_PERMISSAO_CORRECAO_FLUXO.getCodigo());
        Usuario usuario = this.usuarioService.findUsuarioByName(username);
        if (SIM.equalsIgnoreCase(parametroPermissao) && !Boolean.TRUE.equals(UsuarioUtils.isAlteraTodosProc((Usuario)usuario, (Processo)processo))) {
            Tramite ultimoTramiteRecebimento = processo.getUltimoTramiteByFuncao(Funcao.RECEBIDO);
            if (processo.getUltimoTramite().isEmpty()) {
                throw new IllegalStateException(PROCESSO_SEM_ULTIMO_TRAMITE);
            }
            return this.getLocaisUsuario(usuario).contains(ultimoTramiteRecebimento.getLocal());
        }
        return true;
    }
}

