/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.ControleEmail;
import br.com.elotech.protocolo.domain.ControleEmailPK;
import br.com.elotech.protocolo.domain.HistoricoEnvioEmailEntity;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.repository.ControleEmailRepository;
import br.com.elotech.protocolo.service.HistoricoEnvioEmailService;
import br.com.elotech.protocolo.strategy.HistoricoEnvioEmailStrategy;
import java.time.LocalDate;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ControleEmailService
extends CrudService<ControleEmail, ControleEmailPK> {
    private final ControleEmailRepository repository;
    private final HistoricoEnvioEmailStrategy strategy;

    public <T extends HistoricoEnvioEmailEntity<E>, E> void marcarLeitura(ControleEmail controleEmail) {
        HistoricoEnvioEmailService service = this.strategy.get(controleEmail.getId().getTipoOrigem());
        HistoricoEnvioEmailEntity historico = (HistoricoEnvioEmailEntity)service.findById(controleEmail.getId().getId()).orElseThrow(() -> new RegistroNaoEncontradoException(String.format("Hist\u00f3rico de Email tipo [%s] e id [%s] n\u00e3o encontrado", controleEmail.getId().getTipoOrigem(), controleEmail.getId().getId())));
        historico.setDataLeitura(LocalDate.now());
        service.save(historico);
    }

    @Generated
    public ControleEmailService(ControleEmailRepository repository, HistoricoEnvioEmailStrategy strategy) {
        this.repository = repository;
        this.strategy = strategy;
    }
}

