/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.ComprovanteEntrega;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.dto.ComprovanteEntregaDTO;
import br.com.elotech.protocolo.repository.ComprovanteEntregaRepository;
import br.com.elotech.protocolo.repository.PessoaRepository;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.service.EntidadeService;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ComprovanteEntregaService
extends CrudService<ComprovanteEntrega, Long> {
    private final ComprovanteEntregaRepository repository;
    private final EntidadeService entidadeService;
    @Autowired
    private final ProcessoRepository processoRepository;
    @Autowired
    private final PessoaRepository pessoaRepository;

    public ComprovanteEntregaService(ProcessoRepository processoRepository, PessoaRepository pessoaRepository, EntidadeService entidadeService, ComprovanteEntregaRepository repository) {
        this.processoRepository = processoRepository;
        this.pessoaRepository = pessoaRepository;
        this.entidadeService = entidadeService;
        this.repository = repository;
    }

    public ComprovanteEntrega initializeTemplate(Authentication authentication) {
        ComprovanteEntrega comprovanteEntrega = new ComprovanteEntrega();
        comprovanteEntrega.setEntidade(this.entidadeService.getEntidadeAtual());
        return comprovanteEntrega;
    }

    public void newComprovanteEntregaOfDTO(ComprovanteEntregaDTO comprovanteEntregaDTO) {
        if (comprovanteEntregaDTO.getNumero() == null || comprovanteEntregaDTO.getTipo() == null || comprovanteEntregaDTO.getAno() == null) {
            throw new RestException(HttpStatus.BAD_REQUEST, "Dados inv\u00e1lidos do processo.");
        }
        Processo processoSearch = this.processoRepository.findOneByIdAnoAndIdTipoIdAndIdNumero(comprovanteEntregaDTO.getAno(), comprovanteEntregaDTO.getTipo(), comprovanteEntregaDTO.getNumero());
        if (processoSearch == null) {
            throw new RestException(HttpStatus.NOT_FOUND, "Processo n\u00e3o encontrado, verifique os dados e tente novamente.");
        }
        if (processoSearch.getUuid() == null) {
            processoSearch.setUuid(UUID.randomUUID().toString());
            this.processoRepository.save((Object)processoSearch);
        }
        Pessoa pessoaSearch = (Pessoa)this.pessoaRepository.findOne((Object)comprovanteEntregaDTO.getPessoa());
        ComprovanteEntrega newComprovante = new ComprovanteEntrega();
        newComprovante.setIdProcesso(processoSearch.getUuid());
        newComprovante.setPessoa(pessoaSearch);
        newComprovante.setEntidade((Entidade)this.entidadeService.findOne((Serializable)comprovanteEntregaDTO.getEntidade()));
        newComprovante.setAttrValuesOfDTO(comprovanteEntregaDTO);
        this.repository.save((Object)newComprovante);
    }
}

