/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.HashMapParamsLoader;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.protocolo.report.RelatorioProtocolo;
import br.com.elotech.protocolo.repository.ProcessoRepository;
import br.com.elotech.protocolo.web.controller.params.RelatorioComprovanteEncaminhamentoParams;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import javax.sql.DataSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Service;

@Service
public class ComprovanteEncaminhamentoProcessoRelatorioService {
    public static final String DATASET_CABECALHO = "Cabe\u00e7alho";
    public static final String DATASET_COMPROVANTE_ENCAMINHAMENTO = "ComprovanteEncaminhamento";
    private static final String COMPROVANTE_ENCAMINHAMENTO = "sql/comprovante-encaminhamento.sql";
    private final DataSource dataSource;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private final ProcessoRepository processoRepository;

    public ComprovanteEncaminhamentoProcessoRelatorioService(DataSource dataSource, ReportFileResolverFactory reportFileResolverFactor, ProcessoRepository processoRepository) {
        this.dataSource = dataSource;
        this.reportFileResolverFactory = reportFileResolverFactor;
        this.processoRepository = processoRepository;
    }

    public byte[] createComprovanteEncaminhamentoPdfReport(RelatorioComprovanteEncaminhamentoParams params) {
        String sql = params.orderBy(FileUtils.readResourceAsString((String)COMPROVANTE_ENCAMINHAMENTO));
        ReportDatasource datasource = ReportDatasource.builder().add(DATASET_CABECALHO, () -> this.processoRepository.getCabecalhoEntidade(params.getEntidade(), params.getExercicio())).add(DATASET_COMPROVANTE_ENCAMINHAMENTO, (ReportDataLoader)DatasetLoaders.jdbc((String)sql, (MapSqlParameterSource)params.toJdbcParameters(), (DataSource)this.dataSource)).params((ParamLoader)new HashMapParamsLoader(params.toJdbcParameters().getValues())).build();
        return EloReportFactory.crystal().reportFile(this.reportFileResolverFactory.fromFile(RelatorioProtocolo.COMPROVANTE_ENCAMINHAMENTO_PROCESSO.getDefaultRpt())).setReportDatasource(datasource).build().exportToPdf();
    }
}

