/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.DuplicateRecordException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.Cidade;
import br.com.elotech.protocolo.domain.UnidadeFederacao;
import br.com.elotech.protocolo.repository.CidadeRepository;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class CidadeService
extends CrudService<Cidade, Long> {
    public CidadeRepository getRepository() {
        return (CidadeRepository)super.getRepository();
    }

    protected void beforeInsert(Cidade entity) {
        List listCidadesDuplicates = this.getRepository().findByDescricaoIgnoreCaseAndUf(entity.getDescricao(), entity.getUf());
        if (!listCidadesDuplicates.isEmpty()) {
            throw new DuplicateRecordException(String.format("Cidade %s do estado %s j\u00e1 cadastrada.", entity.getDescricao(), entity.getUf().getId()));
        }
        super.beforeInsert((EloEntity)entity);
    }

    public List<Cidade> findByDescricaoAndUnidadeFederacao(String descricao, UnidadeFederacao uf) {
        return this.getRepository().findByDescricaoIgnoreCaseAndUf(descricao, uf);
    }
}

