/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.protocolo.dto.EnderecoDTO;
import br.com.elotech.protocolo.dto.ResponseCep;
import java.util.Collections;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.server.ResponseStatusException;

@Service
public class CepService {
    private final RestTemplate restTemplate;

    public CepService(RestTemplateBuilder restTemplateBuilder) {
        this.restTemplate = restTemplateBuilder.build();
    }

    public EnderecoDTO buscaCep(String cep) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        String url = String.format("http://viacep.com.br/ws/%s/json", cep);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        if (((ResponseCep)response.getBody()).hasAllNullFields()) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Cep n\u00e3o encontrado");
        }
        return EnderecoDTO.from((ResponseCep)((ResponseCep)response.getBody()));
    }
}

