/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.exception.DuplicateRecordException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.Bairro;
import br.com.elotech.protocolo.domain.Cidade;
import br.com.elotech.protocolo.repository.BairroRepository;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class BairroService
extends CrudService<Bairro, Long> {
    public BairroRepository getRepository() {
        return (BairroRepository)super.getRepository();
    }

    protected void beforeInsert(Bairro bairro) {
        List lstBairroDuplicado = this.getRepository().findByDescricaoIgnoreCaseAndCidade(bairro.getDescricao(), bairro.getCidade());
        if (!lstBairroDuplicado.isEmpty()) {
            throw new DuplicateRecordException(String.format("Bairro %s da cidade %s j\u00e1 cadastrada.", bairro.getDescricao(), bairro.getCidade().getId()));
        }
    }

    public List<Bairro> findByDescricaoAndCidade(String descricao, Cidade cidade) {
        return this.getRepository().findByDescricaoIgnoreCaseAndCidade(descricao, cidade);
    }
}

