/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.protocolo.config.audit.AuditEventConverter;
import br.com.elotech.protocolo.repository.PersistenceAuditEventRepository;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuditEventService {
    private final PersistenceAuditEventRepository persistenceAuditEventRepository;
    private final AuditEventConverter auditEventConverter;

    public AuditEventService(PersistenceAuditEventRepository persistenceAuditEventRepository, AuditEventConverter auditEventConverter) {
        this.persistenceAuditEventRepository = persistenceAuditEventRepository;
        this.auditEventConverter = auditEventConverter;
    }

    public Page<AuditEvent> findAll(Pageable pageable) {
        return this.persistenceAuditEventRepository.findAll(pageable).map(persistentAuditEvents -> this.auditEventConverter.convertToAuditEvent(persistentAuditEvents));
    }

    public Page<AuditEvent> findByDates(LocalDateTime fromDate, LocalDateTime toDate, Pageable pageable) {
        return this.persistenceAuditEventRepository.findAllByAuditEventDateBetween(fromDate, toDate, pageable).map(persistentAuditEvents -> this.auditEventConverter.convertToAuditEvent(persistentAuditEvents));
    }

    public Optional<AuditEvent> find(Long id) {
        return this.persistenceAuditEventRepository.findById((Object)id).map(arg_0 -> ((AuditEventConverter)this.auditEventConverter).convertToAuditEvent(arg_0));
    }
}

