/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Parametro;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.repository.ParametroRepository;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.ParametroService;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Deprecated
@Service
public class AtualizadorParametroUrlTributosService {
    protected static final String OBSERVACAO_URL_ATUALIZADA = "ATUALIZADA";
    private final ParametroRepository parametroRepository;
    private final ParametroService parametroService;
    private final EntidadeService entidadeService;
    private final ExercicioService exercicioService;
    @Value(value="${elotech.protocolo.integracao.tributos-url:}")
    private String urlTributosDeprecated;
    @Value(value="${elotech.protocolo.integracao.tributos-ignore:false}")
    private boolean ignoreTributosInt;

    public AtualizadorParametroUrlTributosService(ParametroRepository parametroRepository, ParametroService parametroService, EntidadeService entidadeService, ExercicioService exercicioService) {
        this.parametroRepository = parametroRepository;
        this.parametroService = parametroService;
        this.entidadeService = entidadeService;
        this.exercicioService = exercicioService;
    }

    public void atualizar() {
        if (this.ignoreTributosInt) {
            return;
        }
        Entidade entidadePadrao = Optional.ofNullable(this.entidadeService.getEntidadeAtual()).orElseThrow(() -> new RegistroNaoEncontradoException("Entidade atual n\u00e3o definida"));
        Long exercicioAtual = Optional.ofNullable(this.exercicioService.getExercicioAtual()).orElseThrow(() -> new RegistroNaoEncontradoException("Exercicio atual n\u00e3o definido"));
        Long exercicioAnterior = exercicioAtual - 1L;
        Consumer<Parametro> updateParametro = parametro -> {
            if (!OBSERVACAO_URL_ATUALIZADA.equals(parametro.getObservacao())) {
                parametro.setObservacao(OBSERVACAO_URL_ATUALIZADA);
                parametro.setValor(this.urlTributosDeprecated);
                this.parametroRepository.save(parametro);
            }
        };
        Optional.ofNullable(this.parametroService.getByEntidadeAndExercicioAndCodigo(entidadePadrao, exercicioAtual, ParametroEnum.URL_TRIBUTOS.getCodigo())).ifPresent(updateParametro);
        Optional.ofNullable(this.parametroService.getByEntidadeAndExercicioAndCodigo(entidadePadrao, exercicioAnterior, ParametroEnum.URL_TRIBUTOS.getCodigo())).ifPresent(updateParametro);
    }
}

