/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.exception.RegistroNaoEncontradoException;
import br.com.elotech.adm.service.EntidadeLogadaService;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.publisher.Publisher;
import br.com.elotech.protocolo.converter.AssuntoQueueDTOConverter;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.AssuntoArquivo;
import br.com.elotech.protocolo.domain.AssuntoDocumento;
import br.com.elotech.protocolo.domain.Documento;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import br.com.elotech.protocolo.repository.AssuntoDocumentoRepository;
import br.com.elotech.protocolo.repository.AssuntoEntidadeRepository;
import br.com.elotech.protocolo.repository.AssuntoRepository;
import br.com.elotech.protocolo.repository.TipoProcessoRepository;
import br.com.elotech.protocolo.service.util.RsqlEntidadeUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class AssuntoService
extends CrudService<Assunto, Long> {
    private final AssuntoDocumentoRepository assuntoDocumentoRepository;
    private final AssuntoEntidadeRepository assuntoEntidadeRepository;
    private final EntidadeLogadaService entidadeLogadaService;
    private final ProtocoloMapper protocoloMapper;
    private final Publisher publisher;
    private final TipoProcessoRepository tipoProcessoRepository;

    public AssuntoService(AssuntoDocumentoRepository assuntoDocumentoRepository, AssuntoEntidadeRepository assuntoEntidadeRepository, EntidadeLogadaService entidadeLogadaService, ProtocoloMapper protocoloMapper, Publisher publisher, TipoProcessoRepository tipoProcessoRepository) {
        this.assuntoDocumentoRepository = assuntoDocumentoRepository;
        this.assuntoEntidadeRepository = assuntoEntidadeRepository;
        this.entidadeLogadaService = entidadeLogadaService;
        this.protocoloMapper = protocoloMapper;
        this.publisher = publisher;
        this.tipoProcessoRepository = tipoProcessoRepository;
    }

    public AssuntoRepository getRepository() {
        return (AssuntoRepository)super.getRepository();
    }

    public List<AssuntoDocumento> listarDocumentoAssunto(Assunto assunto) {
        return this.assuntoDocumentoRepository.findAllByIdAssuntoOrderByIdDocumento(assunto);
    }

    public List<Documento> getDocumentoAssunto(Assunto assunto) {
        return this.listarDocumentoAssunto(assunto).stream().map(ul -> ul.getId().getDocumento()).collect(Collectors.toList());
    }

    protected void beforeSave(Assunto entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        List assuntos = this.getRepository().findByDescricaoIgnoreCase(entity.getDescricao());
        if (!assuntos.isEmpty() && !((Assunto)assuntos.get(0)).getId().equals(entity.getId())) {
            throw new RestException(HttpStatus.BAD_REQUEST, String.format("J\u00e1 existe um assunto com esta descri\u00e7\u00e3o: %s", ((Assunto)assuntos.get(0)).getDescricao()));
        }
        for (AssuntoDocumento assuntoDocumento : entity.getAssuntoDocumento()) {
            if (entity.equals((Object)assuntoDocumento.getId().getAssunto())) continue;
            assuntoDocumento.getId().setAssunto(entity);
        }
        for (AssuntoArquivo assuntoArquivo : entity.getArquivos()) {
            if (entity.equals((Object)assuntoArquivo.getAssunto())) continue;
            assuntoArquivo.setAssunto(entity);
        }
    }

    @Transactional
    public void removerAssuntoArquivo(Long idAssunto, Long idArquivo) {
        Assunto assunto = (Assunto)this.getRepository().findOne((Object)idAssunto);
        AssuntoArquivo arquivo = (AssuntoArquivo)assunto.buscarArquivoPorArquivoId(idArquivo).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, "Arquivo n\u00e3o encontrado!"));
        assunto.getArquivos().remove(arquivo);
        this.getRepository().save((Object)assunto);
    }

    public List<Assunto> findAllByAssuntoPaiId(Long id) {
        return this.getRepository().findAllByAssuntoPaiId(id);
    }

    public List<Assunto> findAllComFiltroDeEntidadeETipoProcesso(String search, Long entidadeAtual, Pageable pageable, Long tipoProcessoId) {
        TipoProcesso tipoProcesso;
        if (tipoProcessoId != null && !(tipoProcesso = (TipoProcesso)this.tipoProcessoRepository.findById((Object)tipoProcessoId).orElseThrow(() -> new RegistroNaoEncontradoException("Tipo de Processo n\u00e3o encontrado!"))).getAssuntos().isEmpty()) {
            String filtroTipoProcesso = RsqlEntidadeUtil.criaFiltroRsqlEntidade(tipoProcesso.getAssuntos().stream().map(Assunto::getId).collect(Collectors.toList()), (String)"in");
            search = search.concat(StringUtils.isNotBlank((String)search.trim()) ? " and " : "").concat(filtroTipoProcesso);
        }
        return this.findAllComFiltroDeEntidade(search, entidadeAtual, pageable);
    }

    public List<Assunto> findAllComFiltroDeEntidade(String search, Long entidadeAtual, Pageable pageable) {
        Long entidadeLogada = entidadeAtual;
        if (entidadeAtual == null) {
            entidadeLogada = this.entidadeLogadaService.getEntidadeLogada();
        }
        List todosAssuntosVinculadosAEntidades = this.assuntoEntidadeRepository.findAllAssuntosIds();
        List todosAssuntosVinculadosAEntidadeLogada = this.assuntoEntidadeRepository.findAllAssuntosIdsByEntidadeId(entidadeLogada);
        String filtroRsql = RsqlEntidadeUtil.montaRsql((List)todosAssuntosVinculadosAEntidades, (List)todosAssuntosVinculadosAEntidadeLogada, (String)search);
        return this.findByRsql(filtroRsql, pageable).getContent();
    }

    public List<AssuntoDTO> assuntosMaisUtilizados(String username) {
        Long entidade = this.entidadeLogadaService.getEntidadeLogada();
        List ids = this.getRepository().findAllMaisUtilizadosPorUsuario(entidade, username);
        return ids.stream().map(id -> (Assunto)this.getRepository().findOne(id)).map(arg_0 -> ((ProtocoloMapper)this.protocoloMapper).toAssuntoDTO(arg_0)).collect(Collectors.toList());
    }

    protected void afterSave(Assunto assunto, Authentication authentication) {
        this.publisher.publish(OutboxActions.CREATED, (EntityEvent)new AssuntoQueueDTOConverter().to(assunto));
    }

    protected void afterDelete(Assunto assunto, Authentication authentication) {
        this.publisher.publish(OutboxActions.DELETED, (EntityEvent)new AssuntoQueueDTOConverter().to(assunto));
    }

    @Transactional
    public void republish() {
        this.getRepository().findAll().forEach(assunto -> this.publisher.publish(OutboxActions.CREATED, (EntityEvent)new AssuntoQueueDTOConverter().to(assunto)));
    }

    protected void beforeDelete(Assunto entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        this.validateDelete(entity.getId());
    }

    public void validateDelete(Long id) {
        if (Boolean.TRUE.equals(this.getRepository().existsProcessoByAssunto(id))) {
            throw new EloValidationException("Assunto n\u00e3o pode ser exclu\u00eddo, pois est\u00e1 vinculado a um processo");
        }
    }
}

