/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.adm.utils.CharsetConverterUtils;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.AssuntoArquivo;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import br.com.elotech.protocolo.service.AssuntoService;
import br.com.elotech.protocolo.service.arquivo.ArquivoService;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import br.com.elotech.unico.client.dto.EloArquivoDTO;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AssuntoArquivoService {
    private final ArquivoService arquivoService;
    private final AssuntoService assuntoService;
    private final ProtocoloMapper mapper;

    public AssuntoArquivoService(ArquivoService arquivoService, AssuntoService assuntoService, ProtocoloMapper mapper) {
        this.arquivoService = arquivoService;
        this.assuntoService = assuntoService;
        this.mapper = mapper;
    }

    @Transactional
    public AssuntoDTO addArquivo(Assunto assunto, MultipartFile file) {
        ArquivoDTO arquivoSalvoUnico = this.arquivoService.addArquivo(file);
        String fileName = CharsetConverterUtils.removeSymbols((String)file.getOriginalFilename());
        AssuntoArquivo assuntoArquivo = new AssuntoArquivo();
        assuntoArquivo.setArquivoId(arquivoSalvoUnico.getId());
        assuntoArquivo.setNome(fileName);
        assuntoArquivo.setAssunto(assunto);
        assunto.getArquivos().add(assuntoArquivo);
        return this.mapper.toAssuntoDTO((Assunto)this.assuntoService.getRepository().save((Object)assunto));
    }

    public Optional<EloArquivoDTO> downloadArquivo(Long idArquivo) {
        return this.arquivoService.downloadArquivo(idArquivo);
    }

    public void deletarArquivo(Long idArquivo) {
        this.arquivoService.deletarArquivo(idArquivo);
    }
}

