/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.protocolo.domain.AssinaturaConfiguracao;
import br.com.elotech.protocolo.repository.AssinaturaConfiguracaoRepository;
import br.com.elotech.protocolo.service.arquivo.ArquivoService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import br.com.elotech.unico.client.dto.EloArquivoDTO;
import java.time.LocalDateTime;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AssinaturaConfiguracaoService
extends CrudService<AssinaturaConfiguracao, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssinaturaConfiguracaoService.class);
    private final ArquivoService arquivoService;

    public AssinaturaConfiguracaoService(ArquivoService arquivoService) {
        this.arquivoService = arquivoService;
    }

    protected void beforeSave(AssinaturaConfiguracao entity, Authentication authentication) {
        entity.setEntidade(RequestHeaderHelper.getEntidadeLogada());
        super.beforeSave((EloEntity)entity, authentication);
    }

    public AssinaturaConfiguracaoRepository getCrudRepository() {
        return (AssinaturaConfiguracaoRepository)super.getCrudRepository();
    }

    @Transactional
    public AssinaturaConfiguracao addArquivo(AssinaturaConfiguracao config, MultipartFile file, String tipo) {
        Long idArquivo = this.arquivoService.addArquivo(file).getId();
        config.setArquivoDetails(tipo, idArquivo, file.getOriginalFilename());
        return (AssinaturaConfiguracao)this.getCrudRepository().save((Object)config);
    }

    @Transactional
    public AssinaturaConfiguracao deleteArquivo(AssinaturaConfiguracao config, Long idArquivo, String tipo) {
        this.arquivoService.deletarArquivo(idArquivo);
        config.setArquivoDetails(tipo, null, null);
        return (AssinaturaConfiguracao)this.getCrudRepository().save((Object)config);
    }

    public AssinaturaConfiguracao findByEntidade(Long entidade) {
        return this.getCrudRepository().findByEntidade(entidade);
    }

    protected void beforeInsert(AssinaturaConfiguracao entity) {
        if (entity.getDataInicioColunas() == null) {
            entity.setDataInicioColunas(LocalDateTime.now());
        }
    }

    public EloArquivoDTO getEloArquivoCarimbo(AssinaturaConfiguracao configuracaoAssinatura) {
        try {
            return (EloArquivoDTO)this.arquivoService.downloadArquivo(configuracaoAssinatura.getCarimboArquivoId()).orElseThrow();
        }
        catch (Exception e) {
            log.error("Erro ao carregar certificado da assinatura id {}", (Object)configuracaoAssinatura.getCarimboArquivoId(), (Object)e);
            throw new EloValidationException(String.format("Acesse a Configura\u00e7\u00e3o de Assinatura e defina uma Imagem a ser inserida no carimbo. \nArquivo com id: %s", configuracaoAssinatura.getCarimboArquivoId()));
        }
    }

    public EloArquivoDTO getEloArquivoCertificadoDigital(AssinaturaConfiguracao configuracaoAssinatura) {
        try {
            return (EloArquivoDTO)this.arquivoService.downloadArquivo(configuracaoAssinatura.getCertificadoArquivoId()).orElseThrow();
        }
        catch (Exception e) {
            log.error("Erro ao carregar certificado da assinatura id {}", (Object)configuracaoAssinatura.getCertificadoArquivoId(), (Object)e);
            throw new EloValidationException(String.format("Problemas com a configura\u00e7\u00e3o da assinatura.\nArquivo do certificado n\u00e3o foi encontrado. Arquivo com id: %s", configuracaoAssinatura.getCertificadoArquivoId()));
        }
    }

    public AssinaturaConfiguracao getAssinaturaConfiguracao(Long entidade) {
        AssinaturaConfiguracao configuracaoAssinatura = this.findByEntidade(entidade);
        if (Objects.isNull(configuracaoAssinatura)) {
            throw new EloValidationException("Nenhuma configura\u00e7\u00e3o encontrada.");
        }
        return configuracaoAssinatura;
    }
}

