/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.service;

import br.com.elotech.agendamento.client.AgendamentoFeignClient;
import br.com.elotech.agendamento.client.dto.AgendamentoDTO;
import br.com.elotech.agendamento.client.dto.AgendamentoJobDTO;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ProtocoloConfigService;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

@Service
public class AgendamentoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgendamentoService.class);
    private static final String HOST_PARAM = "[HOST]";
    private static final String CRON_TODO_DIA_5HRS = "0 0 5 * * *";
    private static final String PROCESSO_EM_ATRASO_ID = "aviso-processos-vencidos-%s";
    private final AgendamentoFeignClient agendamentoClient;
    private final HttpServletRequest httpServletRequest;
    private final EntidadeService entidadeService;
    private final ProtocoloConfigService protocoloConfigService;

    public Optional<AgendamentoJobDTO> findAgendamento(String idAgendamento) {
        return this.agendamentoClient.find(TenantContextHolder.getCurrentTenantId(), idAgendamento);
    }

    public boolean existeAgendamento(String idAgendamento) {
        return this.findAgendamento(idAgendamento).isPresent();
    }

    public String createAgendamento(AgendamentoDTO dto) {
        if (Objects.isNull(dto.getTenant()) || dto.getTenant().isEmpty()) {
            dto.setTenant(TenantContextHolder.getCurrentTenantId());
        }
        if (dto.getUrl().contains(HOST_PARAM)) {
            String urlCompleta = this.httpServletRequest.getRequestURL().toString();
            String host = StringUtils.split((String)urlCompleta, (String)"/")[1];
            dto.setUrl(dto.getUrl().replace(HOST_PARAM, host));
        }
        return this.agendamentoClient.create(dto);
    }

    public void deleteAgendamento(String idAgendamento) {
        this.agendamentoClient.deleteById(TenantContextHolder.getCurrentTenantId(), idAgendamento);
    }

    public void verificaAgendamentoEmailProcessosEmAtraso(boolean envioEmailHabilitado) {
        if (!this.protocoloConfigService.isModoCloud()) {
            log.warn("Agendamento de envio de emails para processos em atraso n\u00e3o ser\u00e1 realizado por n\u00e3o ser um ambiente cloud");
            return;
        }
        Long entidade = this.entidadeService.getEntidadeAtual().getId();
        String idAgendamento = String.format(PROCESSO_EM_ATRASO_ID, entidade);
        boolean existeAgendamento = this.existeAgendamento(idAgendamento);
        if (envioEmailHabilitado && !existeAgendamento) {
            AgendamentoDTO agendamento = new AgendamentoDTO();
            agendamento.setId(idAgendamento);
            agendamento.setCron(CRON_TODO_DIA_5HRS);
            agendamento.setUrl(String.format("https://%s/protocolo-api/api/processos/email/processos-vencidos/%s", HOST_PARAM, entidade));
            agendamento.setHttpMethod(HttpMethod.POST);
            this.createAgendamento(agendamento);
        }
        if (!envioEmailHabilitado && existeAgendamento) {
            this.deleteAgendamento(idAgendamento);
        }
    }

    @Generated
    public AgendamentoService(AgendamentoFeignClient agendamentoClient, HttpServletRequest httpServletRequest, EntidadeService entidadeService, ProtocoloConfigService protocoloConfigService) {
        this.agendamentoClient = agendamentoClient;
        this.httpServletRequest = httpServletRequest;
        this.entidadeService = entidadeService;
        this.protocoloConfigService = protocoloConfigService;
    }
}

