/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.security;

import br.com.elotech.core.config.AllProfilesCondition;
import br.com.elotech.core.security.SecurityConfigurerCustomize;
import br.com.elotech.core.security.authorization.AuthorizationInterApiProvider;
import br.com.elotech.core.security.jwt.TokenProvider;
import br.com.elotech.core.security.jwt.filter.SecurityFiltersConfigurer;
import br.com.elotech.protocolo.security.AuthenticationClientUnico;
import br.com.elotech.protocolo.security.ProtocoloPublicEndpointsHelper;
import br.com.elotech.protocolo.security.ProtocoloStandaloneAuthenticationProvider;
import br.com.elotech.unico.client.AuthenticationClientUnicoFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true, jsr250Enabled=true)
@Profile(value={"standalone"})
@ComponentScan(basePackages={"br.com.elotech.core.security"}, basePackageClasses={AllProfilesCondition.class})
public class ProtocoloStandaloneSecurityConfiguration
extends WebSecurityConfigurerAdapter
implements SecurityConfigurerCustomize {
    @Autowired
    private TokenProvider tokenProvider;
    @Autowired
    private CorsFilter corsFilter;
    @Autowired
    private AuthorizationInterApiProvider authorizationInterApiProvider;

    @Bean
    public AuthenticationProvider authenticationProvider(UserDetailsService userDetailsService) {
        return new ProtocoloStandaloneAuthenticationProvider(userDetailsService);
    }

    public void configure(HttpSecurity http) {
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry reqs = http.authorizeRequests();
        for (String endpoint : ProtocoloPublicEndpointsHelper.PUBLIC_ENDPOINTS) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)reqs.antMatchers(new String[]{endpoint})).permitAll();
        }
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)reqs.anyRequest()).authenticated().and()).apply((SecurityConfigurerAdapter)this.securityConfigurerAdapter());
    }

    private SecurityFiltersConfigurer securityConfigurerAdapter() {
        return new SecurityFiltersConfigurer(this.tokenProvider, this.corsFilter, this.authorizationInterApiProvider);
    }

    @Bean(name={"authenticationManager"})
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public AuthenticationClientUnico authenticationClientUnico(AuthenticationClientUnicoFeign authenticationClientUnico) {
        return new AuthenticationClientUnico(authenticationClientUnico);
    }
}

