/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.repository.portal.impl;

import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.protocolo.client.portal.EstatisticaPortalDTO;
import br.com.elotech.protocolo.client.portal.EstatisticaPortalParams;
import br.com.elotech.protocolo.client.portal.SerieItemDTO;
import br.com.elotech.protocolo.repository.portal.EstatisticaPortalRepository;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EstatisticaPortalRepositoryImpl
implements EstatisticaPortalRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private static final String MEDIA_RESPOSTAS = "sql/portal/media-respostas-estatistica.sql";
    private static final String ESTATISTICAS = "sql/portal/estatisticas.sql";
    private static final String PROCESSOS_POR_SEXO = "sql/portal/ProcessosPorSexo.sql";
    private static final String PROCESSOS_POR_IDADE = "sql/portal/ProcessosPorIdade.sql";
    private static final String PROCESSOS_POR_ESCOLARIDADE = "sql/portal/ProcessosPorEscolaridade.sql";

    public EstatisticaPortalRepositoryImpl(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public BigDecimal getMediaResposta(EstatisticaPortalParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)MEDIA_RESPOSTAS));
        Optional.ofNullable(params.getExercicio()).ifPresent(item -> query.append(" AND A.ANO = :exercicio\n"));
        this.addEntidadeParam(params, query);
        BigDecimal result = Optional.ofNullable((BigDecimal)this.jdbcTemplate.queryForObject(query.toString(), (SqlParameterSource)this.toJdbcParameter(params), BigDecimal.class)).orElse(BigDecimal.ZERO);
        return result.setScale(2, RoundingMode.HALF_UP);
    }

    public List<EstatisticaPortalDTO> findEstatisticas(EstatisticaPortalParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)ESTATISTICAS));
        this.addEntidadeParam(params, query);
        Optional.ofNullable(params.getExercicio()).ifPresent(item -> query.append(" AND A.ANO = :exercicio\n"));
        query.append(" GROUP BY A.ANO, MES\n").append(" ORDER BY A.ANO, MES");
        return this.jdbcTemplate.query(query.toString(), (SqlParameterSource)this.toJdbcParameter(params), (RowMapper)new BeanPropertyRowMapper(EstatisticaPortalDTO.class));
    }

    public List<SerieItemDTO> findProcessosPorGenero(EstatisticaPortalParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)PROCESSOS_POR_SEXO));
        this.addEntidadeParam(params, query);
        query.append(" GROUP BY A.SEXO");
        return this.jdbcTemplate.query(query.toString(), (RowMapper)new BeanPropertyRowMapper(SerieItemDTO.class));
    }

    public List<SerieItemDTO> findProcessosPorIdade(EstatisticaPortalParams params) {
        String query = FileUtils.readResourceAsString((String)PROCESSOS_POR_IDADE);
        StringBuilder filtro = new StringBuilder();
        this.addEntidadeParam(params, filtro);
        query = query.replace("$[FILTRO]", filtro.toString());
        return this.jdbcTemplate.query(query, (RowMapper)new BeanPropertyRowMapper(SerieItemDTO.class));
    }

    public List<SerieItemDTO> findProcessosPorEscolaridade(EstatisticaPortalParams params) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)PROCESSOS_POR_ESCOLARIDADE));
        this.addEntidadeParam(params, query);
        query.append(" GROUP BY A.ESCOLARIDADE, E.DESCRICAO");
        return this.jdbcTemplate.query(query.toString(), (RowMapper)new BeanPropertyRowMapper(SerieItemDTO.class));
    }

    private void addEntidadeParam(EstatisticaPortalParams params, StringBuilder query) {
        Optional.ofNullable(params.getEntidade()).ifPresent(item -> query.append(" AND A.ENTIDADE = ").append(item).append('\n'));
    }

    private MapSqlParameterSource toJdbcParameter(EstatisticaPortalParams params) {
        MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource();
        Optional.ofNullable(params.getExercicio()).ifPresent(exercicio -> mapSqlParameterSource.addValue("exercicio", exercicio, 2));
        mapSqlParameterSource.addValue("dataAtual", (Object)DateUtils.getCurrentDate(), 91);
        mapSqlParameterSource.addValue("situacaoCancelado", (Object)params.getSituacaoCancelado(), 2);
        return mapSqlParameterSource;
    }
}

