/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.protocolo.dto.TramiteLocalDTO;
import br.com.elotech.protocolo.repository.TramiteRepositoryCustom;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class TramiteRepositoryImpl
implements TramiteRepositoryCustom {
    private final NamedParameterJdbcTemplate namedJdbcTemplate;
    private static final int MINIMO_REGISTROS = 0;
    private static final int MAXIMO_REGISTROS = 10;

    @Autowired
    public TramiteRepositoryImpl(NamedParameterJdbcTemplate namedJdbcTemplate) {
        this.namedJdbcTemplate = namedJdbcTemplate;
    }

    public List<TramiteLocalDTO> findTramitacoesPorLocalByAnoAndEntidade(Long ano, Long entidade) {
        StringBuilder sb = new StringBuilder().append(" select loc.codigo as codigo, loc.descricao as descricao, count(*) as quantidade ").append(" from locais loc ").append(" inner join tramitacao tramite ").append(" on loc.entidade = tramite.entidade and loc.codigo = tramite.local ").append(" where tramite.ano = :ano ").append(" and tramite.entidade = :entidade ").append(" group by loc.codigo, loc.descricao ").append(" order by 3 desc");
        String sql = sb.toString().replaceAll(":ano", ano.toString()).replaceAll(":entidade", entidade.toString());
        List result = this.namedJdbcTemplate.query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(TramiteLocalDTO.class));
        if (result.size() > 10) {
            return result.subList(0, 10);
        }
        return result;
    }
}

