/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.repository.impl;

import br.com.elotech.adm.utils.HtmlUtils;
import br.com.elotech.adm.utils.TypeConverterUtils;
import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.exception.RecordNotFoundException;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.fluent.dataset.Dataset;
import br.com.elotech.fluent.dataset.DatasetRecord;
import br.com.elotech.fluent.dataset.SimpleDataset;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.ProcessoTaxaPOJO;
import br.com.elotech.protocolo.dto.AssuntoQueueDTO;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.PessoaQueueDTO;
import br.com.elotech.protocolo.dto.ProcessoAssuntoDTO;
import br.com.elotech.protocolo.dto.ProcessoPKSimplesDTO;
import br.com.elotech.protocolo.dto.ProcessoQueueDTO;
import br.com.elotech.protocolo.dto.ProcessoRequerenteDTO;
import br.com.elotech.protocolo.dto.QuantidadeProcessosOuvidoriaDTO;
import br.com.elotech.protocolo.dto.SituacaoQueueDTO;
import br.com.elotech.protocolo.dto.TipoProcessoQueueDTO;
import br.com.elotech.protocolo.enums.StatusIntegracaoEnum;
import br.com.elotech.protocolo.report.datasetrecord.CabecalhoProcessoDatasetRecord;
import br.com.elotech.protocolo.report.datasetrecord.CapaProcessoMainDatasetRecord;
import br.com.elotech.protocolo.report.datasetrecord.ComprovanteProcessoDatasetRecord;
import br.com.elotech.protocolo.report.datasetrecord.ProcessoArquivosDatasetRecord;
import br.com.elotech.protocolo.report.datasetrecord.ProcessoContagemMesAnoDatasetRecord;
import br.com.elotech.protocolo.report.datasetrecord.ProcessoDatasetRecord;
import br.com.elotech.protocolo.report.datasetrecord.ProcessoInteressadoDatasetRecord;
import br.com.elotech.protocolo.report.datasetrecord.ProcessoReceberEncaminharDatasetRecord;
import br.com.elotech.protocolo.report.datasetrecord.RequerimentoDatasetRecord;
import br.com.elotech.protocolo.report.datasetrecord.TramitacaoDetalhadaDatasetRecord;
import br.com.elotech.protocolo.repository.ProcessoCustomRepository;
import br.com.elotech.protocolo.web.controller.params.RelatorioProcessoParams;
import br.com.elotech.protocolo.web.controller.params.RelatorioProcessoReceberEncaminharParams;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ProcessoRepositoryImpl
implements ProcessoCustomRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoRepositoryImpl.class);
    private static final String ANOBASE = "anoBase";
    private static final String DATABASE = "dataBase";
    private static final String FUNCOES = "funcoes";
    private static final String USERNAME = "username";
    private static final String ENTIDADE = "entidade";
    private static final String ACESSOTOTAL = "acessoTotal";
    private static final String PROCESSOS_VENCIDOS = "hql/processos-vencidos.hql";
    private static final String PROCESSOS_VENCIDOS_MP = "hql/processos-vencidos-mp.hql";
    private static final String PROCESSOS_A_VENCER = "hql/processos-a-vencer.hql";
    private static final String PROCESSOS_A_VENCER_MP = "hql/processos-a-vencer-mp.hql";
    private static final String PROCESSOS_EM_DIA = "hql/processos-em-dia.hql";
    private static final String PROCESSOS_EM_DIA_MP = "hql/processos-em-dia-mp.hql";
    private static final Long CINCO_ULTIMOS_ANOS = 5L;
    protected static final String COMPROVANTE_NOT_FOUND = "N\u00e3o foi poss\u00edvel encontrar o comprovante do processo";
    protected static final String TRAMITACAO_DETALHADA_NOT_FOUND = "N\u00e3o foi poss\u00edvel encontrar a visualiza\u00e7\u00e3o do processo";
    protected static final String CAPA_PROCESSO_NOT_FOUND = "N\u00e3o foi poss\u00edvel encontrar a capa do processo";
    protected static final String CABECALHO_NOT_FOUND = "Cabe\u00e7alho do processo n\u00e3o encontrado";
    private static final String COMPROVANTE_PROCESSO_SQL = "sql/comprovante-processo.sql";
    private static final String TRAMITACAO_DETALHADA_SQL = "sql/tramitacao-detalhada.sql";
    private static final String PROCESSO_RECEBER_ENCAMINHAR_SQL = "sql/processo-receber-encaminhar.sql";
    private static final String PROCESSO_REQUERENTE = "sql/processo-requerente.sql";
    private static final String CAPA_PROCESSO_SQL = "sql/capa-processo.sql";
    private static final String CABECALHO_PROCESSO = "sql/cabecalho-processo.sql";
    private static final String REQUERIMENTO_PROCESSO = "sql/requerimento-processo.sql";
    private static final String PROCESSO_GERAL = "sql/processos-geral.sql";
    private static final String PROCESSO_ASSUNTO = "sql/quantidade-processos-assunto.sql";
    private static final String PROCESSO_QUEUE = "sql/processo-queue.sql";
    private static final String PROCESSOS_POR_STATUS_INTEGRACAO = "sql/processos-por-status-integracao.sql";
    private static final String QUANTIDADE_PROCESSO_OUVIDORIA_STATUS = "sql/quantidade-processos-ouvidoria-status.sql";
    private static final String QUANTIDADE_PROCESSO_OUVIDORIA_POR_TIPO = "sql/quantidade-processos-ouvidoria-por-tipo.sql";
    public static final String ENTIDADE_UPPER = "ENTIDADE";
    public static final String DATAPROCESSO = "DATAPROCESSO";
    private static final String OUVIDORIA = "OUVIDORIA";
    private static final String INTERNO = "INTERNO";
    private static final String EXTERNO = "EXTERNO";
    private final JdbcTemplate jdbcTemplate;
    private final NamedParameterJdbcTemplate namedJdbcTemplate;
    private final EntityManager em;

    @Autowired
    public ProcessoRepositoryImpl(JdbcTemplate jdbcTemplate, NamedParameterJdbcTemplate namedJdbcTemplate, EntityManager em) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedJdbcTemplate = namedJdbcTemplate;
        this.em = em;
    }

    public Dataset<ComprovanteProcessoDatasetRecord> getComprovanteProcesso(Processo processo) {
        String sql = FileUtils.readResourceAsString((String)COMPROVANTE_PROCESSO_SQL);
        Object[] args = this.createProcessoTramiteArgs(processo);
        List result = this.jdbcTemplate.query(sql, args, (RowMapper)new ElotechBeanPropertyRowMapper(ComprovanteProcessoDatasetRecord.class));
        return (Dataset)result.stream().findFirst().map(m -> {
            try {
                m.setDigitacao(TypeConverterUtils.stringToClobConverter((String)HtmlUtils.toText((String)TypeConverterUtils.clobToStringConverter((Clob)m.getDigitacao()))));
            }
            catch (IOException | SQLException e) {
                log.error(e.getMessage());
            }
            return SimpleDataset.single((DatasetRecord)m, ComprovanteProcessoDatasetRecord.class);
        }).orElseThrow(() -> new RecordNotFoundException(COMPROVANTE_NOT_FOUND));
    }

    public Dataset<CapaProcessoMainDatasetRecord> getCapaProcesso(Processo processo) {
        String sql = FileUtils.readResourceAsString((String)CAPA_PROCESSO_SQL);
        Object[] args = this.createProcessoPkArgs(processo);
        List result = this.jdbcTemplate.query(sql, args, (RowMapper)new ElotechBeanPropertyRowMapper(CapaProcessoMainDatasetRecord.class));
        return (Dataset)result.stream().findFirst().map(m -> SimpleDataset.single((DatasetRecord)m, CapaProcessoMainDatasetRecord.class)).orElseThrow(() -> new RecordNotFoundException(CAPA_PROCESSO_NOT_FOUND));
    }

    public Dataset<TramitacaoDetalhadaDatasetRecord> getVisualizacaoProcesso(Processo processo) {
        String sql = FileUtils.readResourceAsString((String)TRAMITACAO_DETALHADA_SQL);
        Object[] args = this.createProcessoPkArgs(processo);
        List result = this.jdbcTemplate.query(sql, args, (RowMapper)new ElotechBeanPropertyRowMapper(TramitacaoDetalhadaDatasetRecord.class));
        return SimpleDataset.of((List)result, TramitacaoDetalhadaDatasetRecord.class);
    }

    public Dataset<ProcessoArquivosDatasetRecord> getProcessosArquivosDataSetRecord(Processo processo) {
        List processoArquivosDatasetRecords = processo.getArquivos().stream().sorted(Comparator.comparing(ProcessoArquivo::getDataCriacao)).map(ProcessoArquivosDatasetRecord::new).collect(Collectors.toList());
        return SimpleDataset.of(processoArquivosDatasetRecords, ProcessoArquivosDatasetRecord.class);
    }

    public Dataset<ProcessoInteressadoDatasetRecord> getProcessoInteressadoDatasetRecord(Processo processo) {
        List processoInteressadoDatasetRecords = processo.getInteressados().stream().map(ProcessoInteressadoDatasetRecord::new).collect(Collectors.toList());
        return SimpleDataset.of(processoInteressadoDatasetRecords, ProcessoInteressadoDatasetRecord.class);
    }

    public Dataset<RequerimentoDatasetRecord> getRequerimentoProcesso(Processo processo) {
        String sql = FileUtils.readResourceAsString((String)REQUERIMENTO_PROCESSO);
        Object[] args = this.createProcessoPkArgs(processo);
        List result = this.jdbcTemplate.query(sql, args, (RowMapper)new ElotechBeanPropertyRowMapper(RequerimentoDatasetRecord.class));
        return (Dataset)result.stream().findFirst().map(m -> SimpleDataset.single((DatasetRecord)m, RequerimentoDatasetRecord.class)).orElseThrow(() -> new RecordNotFoundException(REQUERIMENTO_PROCESSO));
    }

    public Dataset<ProcessoDatasetRecord> getProcessoGeral(RelatorioProcessoParams params) {
        MapSqlParameterSource jdbcParameters = params.toJdbcParameters();
        String sql = FileUtils.readResourceAsString((String)PROCESSO_GERAL);
        sql = sql.replaceAll(":grupo1", params.getGrupo1());
        sql = sql.replaceAll(":grupo2", params.getGrupo2());
        sql = sql.replaceAll(":grupo3", params.getGrupo3());
        sql = sql.replaceAll("GERAL AS", "'GERAL' AS");
        List registros = this.namedJdbcTemplate.query(sql, (SqlParameterSource)jdbcParameters, (RowMapper)new ElotechBeanPropertyRowMapper(ProcessoDatasetRecord.class));
        return SimpleDataset.of((List)registros, ProcessoDatasetRecord.class);
    }

    public Dataset<ProcessoReceberEncaminharDatasetRecord> getProcessoReceberEncaminharDatasetRecord(RelatorioProcessoReceberEncaminharParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)PROCESSO_RECEBER_ENCAMINHAR_SQL));
        if (Objects.nonNull(params.getTipo())) {
            sql.append(" AND p.tipo = :tipo ");
        }
        if (Objects.nonNull(params.getNumero())) {
            sql.append(" AND p.numero = :numero ");
        }
        if (Objects.nonNull(params.getAno())) {
            sql.append(" AND p.ano = :ano ");
        }
        if (Objects.nonNull(params.getLocalDestino())) {
            sql.append(" AND p.localDestino = :localDestino ");
        }
        if (Objects.nonNull(params.getDataDestino())) {
            sql.append(" AND p.dataDestino = :dataDestino ");
        }
        if (Objects.nonNull(params.getNomeRequerente()) && !params.getNomeRequerente().isEmpty()) {
            sql.append(" AND tiraacento(LOWER(pes.nome)) LIKE tiraacento(LOWER('%".concat(params.getNomeRequerente().concat("%')) ")));
        }
        sql.append(" ORDER BY P.LOCALDESTINO, CASE WHEN P.LOCALATUAL <> P.LOCALDESTINO THEN 'RECEBER' ELSE 'ENCAMINHAR' END ");
        List result = this.namedJdbcTemplate.query(sql.toString(), (SqlParameterSource)params.toJdbcParameters(), (RowMapper)new ElotechBeanPropertyRowMapper(ProcessoReceberEncaminharDatasetRecord.class));
        return SimpleDataset.of((List)result, ProcessoReceberEncaminharDatasetRecord.class);
    }

    private Object[] createProcessoTramiteArgs(Processo processo) {
        ProcessoPK pk = processo.getId();
        return new Object[]{pk.getTipo().getId(), pk.getAno(), pk.getNumero(), pk.getEntidade().getId(), processo.getUltimaSequenciaTramite()};
    }

    public Dataset<CabecalhoProcessoDatasetRecord> getCabecalhoEntidade(Long entidade, Long exercicio) {
        String sql = FileUtils.readResourceAsString((String)CABECALHO_PROCESSO);
        Object[] args = new Object[]{entidade, exercicio};
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(CabecalhoProcessoDatasetRecord.class);
        List result = this.jdbcTemplate.query(sql, args, (RowMapper)rowMapper);
        return (Dataset)result.stream().findFirst().map(m -> SimpleDataset.single((DatasetRecord)m, CabecalhoProcessoDatasetRecord.class)).orElseThrow(() -> new RecordNotFoundException(CABECALHO_NOT_FOUND));
    }

    private Object[] createProcessoPkArgs(Processo processo) {
        ProcessoPK pk = processo.getId();
        return new Object[]{pk.getTipo().getId(), pk.getAno(), pk.getNumero(), pk.getEntidade().getId()};
    }

    public Page<Processo> getProcessosVencidos(LocalDate dataBase, String username, Long entidade, Boolean usuarioAcessoTotal, Boolean isProcessoMP) {
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ABERTO, Funcao.RECEBIDO, Funcao.ENCAMINHADO});
        String hql = FileUtils.readResourceAsString((String)(Boolean.TRUE.equals(isProcessoMP) ? PROCESSOS_VENCIDOS_MP : PROCESSOS_VENCIDOS));
        TypedQuery query = this.em.createQuery(hql, Processo.class).setParameter(ENTIDADE, (Object)entidade).setParameter(USERNAME, (Object)username).setParameter(FUNCOES, (Object)funcoes).setParameter(DATABASE, (Object)dataBase).setParameter(ACESSOTOTAL, (Object)usuarioAcessoTotal).setParameter(ANOBASE, (Object)((long)dataBase.getYear() - CINCO_ULTIMOS_ANOS));
        return new PageImpl(query.getResultList());
    }

    public Page<Processo> getProcessosAVencer(LocalDate dataBase, String username, Long diasAVencer, Long entidade, Boolean usuarioAcessoTotal, Boolean isProcessoMP, Long qtdDiasAVencerMP) {
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ABERTO, Funcao.RECEBIDO, Funcao.ENCAMINHADO});
        String hql = FileUtils.readResourceAsString((String)(Boolean.TRUE.equals(isProcessoMP) ? PROCESSOS_A_VENCER_MP : PROCESSOS_A_VENCER));
        TypedQuery query = this.em.createQuery(hql, Processo.class).setParameter(ENTIDADE, (Object)entidade).setParameter(FUNCOES, (Object)funcoes).setParameter(USERNAME, (Object)username).setParameter(DATABASE, (Object)dataBase).setParameter(ACESSOTOTAL, (Object)usuarioAcessoTotal).setParameter(ANOBASE, (Object)((long)dataBase.getYear() - CINCO_ULTIMOS_ANOS));
        if (Boolean.TRUE.equals(isProcessoMP)) {
            query.setParameter("quantidadeDias", (Object)qtdDiasAVencerMP);
        } else {
            query.setParameter("dataBaseInc", (Object)dataBase.plusDays(diasAVencer));
        }
        return new PageImpl(query.getResultList());
    }

    public Page<Processo> getProcessosEmDia(LocalDate dataBase, String username, Long entidade, Boolean usuarioAcessoTotal, Boolean isProcessoMP, Long qtdDiasAVencerMP) {
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ABERTO, Funcao.RECEBIDO, Funcao.ENCAMINHADO});
        String hql = FileUtils.readResourceAsString((String)(Boolean.TRUE.equals(isProcessoMP) ? PROCESSOS_EM_DIA_MP : PROCESSOS_EM_DIA));
        TypedQuery query = this.em.createQuery(hql, Processo.class).setParameter(ENTIDADE, (Object)entidade).setParameter(FUNCOES, (Object)funcoes).setParameter(USERNAME, (Object)username).setParameter(DATABASE, (Object)dataBase).setParameter(ACESSOTOTAL, (Object)usuarioAcessoTotal).setParameter(ANOBASE, (Object)((long)dataBase.getYear() - CINCO_ULTIMOS_ANOS));
        if (Boolean.TRUE.equals(isProcessoMP)) {
            query.setParameter("quantidadeDias", (Object)qtdDiasAVencerMP);
        }
        return new PageImpl(query.getResultList());
    }

    public List<ProcessoRequerenteDTO> findByPessoaId(Long codPessoa) {
        String sql = FileUtils.readResourceAsString((String)PROCESSO_REQUERENTE);
        sql = sql.replaceAll(":codPessoa", codPessoa.toString());
        return this.namedJdbcTemplate.query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(ProcessoRequerenteDTO.class));
    }

    public List<ProcessoAssuntoDTO> findProcessosPorAssuntoByEntidadeAndAno(Long entidade, Long ano) {
        String sql = FileUtils.readResourceAsString((String)PROCESSO_ASSUNTO);
        sql = sql.replaceAll(":entidade", entidade.toString());
        sql = sql.concat(" where proc.externo = 'S'");
        if (ano != null) {
            sql = sql.concat(" and proc.ano = :ano ").replaceAll(":ano", ano.toString());
        }
        sql = sql.concat(" group by ass.codigo, ass.descricao order by 2 desc");
        return this.namedJdbcTemplate.query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(ProcessoAssuntoDTO.class));
    }

    public ProcessoQueueDTO findProcessosPorUuid(String uuid) {
        String sql = FileUtils.readResourceAsString((String)PROCESSO_QUEUE);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("uuid", (Object)uuid);
        return (ProcessoQueueDTO)this.namedJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (resultSet, i) -> {
            AssuntoQueueDTO assuntoQueue = new AssuntoQueueDTO();
            assuntoQueue.setAssunto(Long.valueOf(resultSet.getLong("codassunto")));
            assuntoQueue.setDescricao(resultSet.getString("assunto"));
            assuntoQueue.setTempoArquivamento(Long.valueOf(resultSet.getLong("prazoarquivamento")));
            assuntoQueue.setComplemento(resultSet.getString("complemento"));
            SituacaoQueueDTO situacaoQueue = new SituacaoQueueDTO();
            situacaoQueue.setSituacao(Long.valueOf(resultSet.getLong("codsituacao")));
            situacaoQueue.setDescricao(resultSet.getString("situacao"));
            TipoProcessoQueueDTO tipoProcessoQueue = new TipoProcessoQueueDTO();
            tipoProcessoQueue.setTipoProcesso(Long.valueOf(resultSet.getLong("codtipo")));
            tipoProcessoQueue.setDescricao(resultSet.getString("tipo"));
            PessoaQueueDTO queuePessoa = new PessoaQueueDTO();
            queuePessoa.setCnpjCpf(resultSet.getString("cnpj_cpf"));
            Date dataNascimento = resultSet.getDate("datanascimento");
            if (dataNascimento != null) {
                queuePessoa.setDataNascimento(dataNascimento.toLocalDate());
            }
            queuePessoa.setNome(resultSet.getString("nome"));
            queuePessoa.setPessoa(Long.valueOf(resultSet.getLong("codpessoa")));
            queuePessoa.setIdUnico(Long.valueOf(resultSet.getLong("idunico")));
            ProcessoQueueDTO processoQueue = new ProcessoQueueDTO();
            processoQueue.setExercicio(Long.valueOf(resultSet.getLong("ano")));
            processoQueue.setEntidade(Long.valueOf(resultSet.getLong(ENTIDADE)));
            processoQueue.setProcesso(Long.valueOf(resultSet.getLong("numero")));
            processoQueue.setIdProcesso(Long.valueOf(resultSet.getLong("numero")));
            processoQueue.setDigitacao(resultSet.getString("digitacao"));
            processoQueue.setQuadra(resultSet.getString("quadra"));
            processoQueue.setObservacao(resultSet.getString("outrosdados"));
            processoQueue.setZona(resultSet.getString("zona"));
            processoQueue.setDataProcesso(resultSet.getDate("dataProcesso").toLocalDate());
            processoQueue.setTipoProcesso(tipoProcessoQueue);
            processoQueue.setSituacao(situacaoQueue);
            processoQueue.setAssunto(assuntoQueue);
            processoQueue.setPessoa(queuePessoa);
            processoQueue.setUuid(uuid);
            return processoQueue;
        });
    }

    public List<ProcessoPKSimplesDTO> findAllProcessosByStatusIntegracao(Set<StatusIntegracaoEnum> status) {
        if (status.isEmpty()) {
            return List.of();
        }
        String sql = FileUtils.readResourceAsString((String)PROCESSOS_POR_STATUS_INTEGRACAO).replace("{STATUS}", status.stream().map(statusIntegracaoEnum -> String.format("'%s'", statusIntegracaoEnum.getValue())).collect(Collectors.joining(", ")));
        return this.namedJdbcTemplate.query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(ProcessoPKSimplesDTO.class));
    }

    public List<ProcessoTaxaPOJO> findAllProcessosComDebitosNaoPago(Long entidade, Date dataProcesso) {
        String sql = "SELECT P.TIPO as tipo, P.BOLETOPAGO as boletoPago, P.ANO as ano, P.NUMERO as numero, P.ENTIDADE as entidade, T.IDDEBITO as idDebitoDTO FROM PROCESSOS P JOIN PROCESSO_TAXAS T    ON P.IDPROCESSOTAXA = T.ID  WHERE   P.BOLETOPAGO = 'N'      AND P.IDPROCESSOTAXA IS NOT NULL     AND T.IDDEBITO IS NOT NULL AND P.DATAPROCESSO >= TO_DATE(:DATAPROCESSO, 'YYYY-MM-DD') AND P.ENTIDADE = CAST(:ENTIDADE AS INTEGER)";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DATAPROCESSO, dataProcesso.toString());
        params.put(ENTIDADE_UPPER, entidade.toString());
        return this.namedJdbcTemplate.query(sql, params, (RowMapper)new ElotechBeanPropertyRowMapper(ProcessoTaxaPOJO.class));
    }

    public List<QuantidadeProcessosOuvidoriaDTO> findQuantidadeProcessosOuvidoriaPorTipo(Entidade entidade) {
        String sql = FileUtils.readResourceAsString((String)QUANTIDADE_PROCESSO_OUVIDORIA_POR_TIPO);
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put(ENTIDADE_UPPER, entidade.getId());
        return this.namedJdbcTemplate.query(sql, params, (RowMapper)new ElotechBeanPropertyRowMapper(QuantidadeProcessosOuvidoriaDTO.class));
    }

    public List<ProcessoContagemMesAnoDatasetRecord> relatorioContagemPorMesEAno(Long ano, Long idEntidade, Long idLocal, Long idAssunto, Long idSituacao, String complementoAssunto, String idUsuario, Boolean somenteArquivados, String ouvidoria) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        StringBuilder builder = new StringBuilder("select q.mes, q.ano, count(1) as processos from (    select         extract(year from p.dataprocesso) as ano,        extract(month from p.dataprocesso) as mes    from processos p    left join assunto a on p.codassunto = a.codigo    where  p.entidade = :ENTIDADE");
        params.addValue(ENTIDADE_UPPER, (Object)idEntidade);
        if (somenteArquivados.booleanValue()) {
            builder.append(" and p.status = 'A'");
        }
        if (ano != null) {
            builder.append(" and p.ano = :ANO");
            params.addValue("ANO", (Object)ano);
        }
        if (idLocal != null) {
            builder.append(" and p.localatual = :LOCAL");
            params.addValue("LOCAL", (Object)idLocal);
        }
        if (idAssunto != null) {
            builder.append(" and p.codassunto = :CODASSUNTO");
            params.addValue("CODASSUNTO", (Object)idAssunto);
        }
        if (idSituacao != null) {
            builder.append(" and p.situacao = :SITUACAO");
            params.addValue("SITUACAO", (Object)idSituacao);
        }
        if (complementoAssunto != null) {
            builder.append(" and UPPER(p.assunto) like :ASSUNTO");
            params.addValue("ASSUNTO", (Object)("%" + complementoAssunto.toUpperCase() + "%"));
        }
        if (idUsuario != null) {
            builder.append(" and p.usuarioreg = :USUARIO");
            params.addValue("USUARIO", (Object)idUsuario);
        }
        if (OUVIDORIA.equals(ouvidoria)) {
            builder.append(" and a.ouvidoria = 'S' and a.assuntointerno = 'N'");
        }
        if (INTERNO.equals(ouvidoria)) {
            builder.append(" and a.ouvidoria = 'N' and a.assuntointerno = 'S'");
        }
        if (EXTERNO.equals(ouvidoria)) {
            builder.append(" and a.ouvidoria = 'N' and a.assuntointerno = 'N'");
        }
        builder.append(" ) q  group by q.mes, q.ano order by q.mes, q.ano asc ");
        String sql = builder.toString();
        return this.namedJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(ProcessoContagemMesAnoDatasetRecord.class));
    }

    public List<QuantidadeProcessosOuvidoriaDTO> findQuantidadeProcessosOuvidoriaPorStatus(Entidade entidade) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put(ENTIDADE_UPPER, entidade.getId());
        String sql = FileUtils.readResourceAsString((String)QUANTIDADE_PROCESSO_OUVIDORIA_STATUS);
        return this.namedJdbcTemplate.query(sql, params, (RowMapper)new ElotechBeanPropertyRowMapper(QuantidadeProcessosOuvidoriaDTO.class));
    }

    public Long getNumeroRecomendado(ProcessoPK pk, String expression) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        StringBuilder sql = new StringBuilder(" SELECT (COALESCE(max(numero), 0) + 1) FROM processos WHERE 1 = 1 ");
        if (expression.contains("GEN_PROCESSO")) {
            sql.append(" and dataprocesso = :dataprocesso ");
            params.addValue("dataprocesso", (Object)new java.util.Date(), 91);
        }
        if (expression.contains("tipo")) {
            sql.append(" and tipo = :tipo ");
            params.addValue("tipo", (Object)pk.getTipo().getId());
        }
        if (expression.contains(ENTIDADE)) {
            sql.append(" and entidade = :entidade ");
            params.addValue(ENTIDADE, (Object)pk.getEntidade().getId());
        }
        if (expression.contains("ano")) {
            sql.append(" and ano = :ano ");
            params.addValue("ano", (Object)pk.getAno());
        }
        return (Long)this.namedJdbcTemplate.queryForObject(sql.toString(), (SqlParameterSource)params, Long.class);
    }
}

