/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.repository.impl;

import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.repository.LocalCustomRepository;
import br.com.elotech.protocolo.repository.UsuarioLocalRepository;
import br.com.elotech.protocolo.specs.UsuarioLocalSpecificationHelper;
import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;

@Repository
public class LocalRepositoryImpl
implements LocalCustomRepository {
    private static final Character LIKE_OP = Character.valueOf('%');
    private final UsuarioLocalRepository usuarioLocalRepository;

    public LocalRepositoryImpl(UsuarioLocalRepository usuarioLocalRepository) {
        this.usuarioLocalRepository = usuarioLocalRepository;
    }

    public Page<Local> searchByUsuarioAndDescricao(String usuario, String descricao, Long local, Pageable page, Long entidadeId) {
        Locale locale = LocaleContextHolder.getLocale();
        Specification spec = Specification.where((Specification)UsuarioLocalSpecificationHelper.byUsuario((String)usuario)).and(UsuarioLocalSpecificationHelper.byAtivo());
        if (!Strings.isNullOrEmpty((String)descricao)) {
            spec = spec.and(UsuarioLocalSpecificationHelper.byDescricaoLocalLike((String)(LIKE_OP + descricao.toUpperCase(locale).replace(' ', LIKE_OP.charValue()) + LIKE_OP)));
        }
        if (local != null) {
            spec = spec.and(UsuarioLocalSpecificationHelper.byIdLocal((Long)local));
        }
        spec = spec.and(UsuarioLocalSpecificationHelper.byEntidadeId((Long)entidadeId));
        Page pageLocaisUsuario = this.usuarioLocalRepository.findAll(spec, (Pageable)PageRequest.of((int)page.getPageNumber(), (int)page.getPageSize()));
        List locais = pageLocaisUsuario.getContent().stream().map(ul -> ul.getId().getLocal()).sorted(Comparator.comparing(l -> l.getId().getId())).collect(Collectors.toList());
        return new PageImpl(locais);
    }

    public List<Local> findByUsuario(String usuario) {
        return this.usuarioLocalRepository.findAll(Specification.where((Specification)UsuarioLocalSpecificationHelper.byUsuario((String)usuario))).stream().map(ul -> ul.getId().getLocal()).sorted(Comparator.comparing(Local::getDescricao)).collect(Collectors.toList());
    }
}

