/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.protocolo.dto.IndicadorProcessosLocaisDTO;
import br.com.elotech.protocolo.dto.params.IndicadorProcessosLocaisParams;
import br.com.elotech.protocolo.repository.IndicadoresRepository;
import java.sql.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class IndicadoresRepositoryImpl
implements IndicadoresRepository {
    private final NamedParameterJdbcTemplate namedJdbcTemplate;

    @Autowired
    public IndicadoresRepositoryImpl(NamedParameterJdbcTemplate namedJdbcTemplate) {
        this.namedJdbcTemplate = namedJdbcTemplate;
    }

    public List<IndicadorProcessosLocaisDTO> getProcessosLocais(IndicadorProcessosLocaisParams dtoParams) {
        String sql = " select p.localatual as id, " + " count(p.numero) as processosLocal, " + " (select count(p2.numero) from processos p2 where p.localatual = p2.localatual and p2.status = 'E') as processosReceber " + " from processos p " + " where p.localatual in (:ids) " + " and p.dataprocesso between :dataInicial and :dataFinal " + " group by p.localatual ";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("ids", (Object)dtoParams.getLocais());
        params.addValue("dataInicial", (Object)Date.valueOf(dtoParams.getDataInicial()), 91);
        params.addValue("dataFinal", (Object)Date.valueOf(dtoParams.getDataFinal()), 91);
        return this.namedJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(IndicadorProcessosLocaisDTO.class));
    }
}

