/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.repository.impl;

import br.com.elotech.adm.exception.DownloadArquivoException;
import br.com.elotech.adm.utils.CharsetConverterUtils;
import br.com.elotech.core.jpa.hibernate.HibernateUtils;
import br.com.elotech.protocolo.converter.EloArquivoDTOConverter;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.repository.ArquivoRepository;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import br.com.elotech.unico.client.dto.EloArquivoContentDTO;
import br.com.elotech.unico.client.dto.EloArquivoDTO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.internal.SessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.web.multipart.MultipartFile;

@Repository
@Profile(value={"!cloud"})
public class ArquivoRepositoryImpl
implements ArquivoRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ArquivoRepositoryImpl.class);
    public static final String ELOARQUIVO_SCHEMA = "${eloarquivo}";
    private static final String SQL_INSERT_ARQUIVO = "INSERT INTO ${eloarquivo}.ARQUIVO (ID, NOME, DATACRIACAO, MIMETYPE) VALUES (?, ?, ?, ?)";
    private static final String SQL_INSERT_ARQUIVO_CONTENT = "INSERT INTO ${eloarquivo}.ARQUIVO_CONTENT (ID, ARQUIVO) VALUES (?, ?)";
    private static final String SQL_SELECT_ARQUIVO = "SELECT ID, NOME, DATACRIACAO FROM ${eloarquivo}.ARQUIVO WHERE ID = ?";
    private static final String SQL_SELECT_ARQUIVO_CONTENT = "SELECT ac.arquivo AS binary, a.mimetype AS mimetype FROM ${eloarquivo}.arquivo_content ac INNER JOIN ${eloarquivo}.arquivo a ON a.id = ac.id WHERE a.id = ?";
    private final JdbcTemplate jdbcTemplate;
    private final String sqlSequenceNextVal;
    private final String schemaEloarqivo;

    @Autowired
    public ArquivoRepositoryImpl(EntityManagerFactory emFactory, JdbcTemplate jdbcTemplate, @Value(value="${db.eloarquivo.schema:eloarquivo}") String schemaEloarqivo) {
        this.schemaEloarqivo = schemaEloarqivo;
        EntityManager em = emFactory.createEntityManager();
        SessionImpl session = (SessionImpl)em.unwrap(SessionImpl.class);
        this.sqlSequenceNextVal = HibernateUtils.getDialect((SessionImpl)session).getSelectSequenceNextValString(this.schemaEloarqivo.concat(".GEN_ELOARQUIVO"));
        this.jdbcTemplate = jdbcTemplate;
    }

    public ArquivoDTO saveArquivo(MultipartFile file) {
        String sqlInsertArquivo = SQL_INSERT_ARQUIVO.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        String sqlInsertArquivoContent = SQL_INSERT_ARQUIVO_CONTENT.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        Long idArquivo = (Long)this.jdbcTemplate.queryForObject("SELECT " + this.sqlSequenceNextVal + " FROM DUAL", new Object[0], Long.class);
        String fileName = CharsetConverterUtils.sanitize((String)file.getOriginalFilename());
        this.jdbcTemplate.update(sqlInsertArquivo, new Object[]{idArquivo, fileName, Date.valueOf(LocalDate.now()), file.getContentType()});
        this.jdbcTemplate.update(sqlInsertArquivoContent, new Object[]{idArquivo, file.getBytes()});
        String sqlSelectArquivo = SQL_SELECT_ARQUIVO.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        EloArquivoDTO eloArquivo = (EloArquivoDTO)this.jdbcTemplate.queryForObject(sqlSelectArquivo, new Object[]{idArquivo}, (RowMapper)new BeanPropertyRowMapper(EloArquivoDTO.class));
        return new EloArquivoDTOConverter().to(eloArquivo);
    }

    public ArquivoDTO saveArquivo(File file) {
        if (!file.exists()) {
            throw new FileNotFoundException("N\u00e3o encontrado arquivo " + file.getPath());
        }
        String sqlInsertArquivo = SQL_INSERT_ARQUIVO.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        String sqlInsertArquivoContent = SQL_INSERT_ARQUIVO_CONTENT.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        Long idArquivo = (Long)this.jdbcTemplate.queryForObject("SELECT " + this.sqlSequenceNextVal + " FROM DUAL", new Object[0], Long.class);
        String fileName = CharsetConverterUtils.sanitize((String)file.getName());
        this.jdbcTemplate.update(sqlInsertArquivo, new Object[]{idArquivo, fileName, Date.valueOf(LocalDate.now()), Files.probeContentType(file.toPath())});
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.jdbcTemplate.update(con -> {
                PreparedStatement ps = con.prepareStatement(sqlInsertArquivoContent);
                ps.setLong(1, idArquivo);
                ps.setBinaryStream(2, (InputStream)fileInputStream, (int)file.length());
                return ps;
            });
        }
        String sqlSelectArquivo = SQL_SELECT_ARQUIVO.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        EloArquivoDTO eloArquivo = (EloArquivoDTO)this.jdbcTemplate.queryForObject(sqlSelectArquivo, new Object[]{idArquivo}, (RowMapper)new BeanPropertyRowMapper(EloArquivoDTO.class));
        return new EloArquivoDTOConverter().to(eloArquivo);
    }

    public Optional<EloArquivoDTO> getArquivo(Long id) {
        String sqlSelectArquivo = SQL_SELECT_ARQUIVO.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        String sqlSelectArquivoContent = SQL_SELECT_ARQUIVO_CONTENT.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        try {
            EloArquivoDTO eloArquivo = (EloArquivoDTO)this.jdbcTemplate.queryForObject(sqlSelectArquivo, new Object[]{id}, (RowMapper)new BeanPropertyRowMapper(EloArquivoDTO.class));
            EloArquivoContentDTO content = (EloArquivoContentDTO)this.jdbcTemplate.queryForObject(sqlSelectArquivoContent, new Object[]{id}, (RowMapper)new BeanPropertyRowMapper(EloArquivoContentDTO.class));
            eloArquivo.setContent(content);
            return Optional.of(eloArquivo);
        }
        catch (EmptyResultDataAccessException e) {
            LOG.error("Consulta de arquivo com o id {} n\u00e3o retornou nada. {}", new Object[]{id, e.getMessage(), e});
            return Optional.empty();
        }
    }

    public File getArquivoFisico(Long id, String path) {
        String sqlSelectArquivo = SQL_SELECT_ARQUIVO.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        String sqlSelectArquivoContent = SQL_SELECT_ARQUIVO_CONTENT.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        try {
            EloArquivoDTO eloArquivo = (EloArquivoDTO)this.jdbcTemplate.queryForObject(sqlSelectArquivo, new Object[]{id}, new int[]{2}, (RowMapper)new BeanPropertyRowMapper(EloArquivoDTO.class));
            this.jdbcTemplate.query(sqlSelectArquivoContent, new Object[]{eloArquivo.getId()}, new int[]{2}, rs -> this.readResultSetBinaryStream(rs, path));
            return new File(path);
        }
        catch (EmptyResultDataAccessException e) {
            LOG.error("Consulta de arquivo com o id {} n\u00e3o retornou nada. {}", new Object[]{id, e.getMessage(), e});
            throw new EmptyResultDataAccessException(String.format("Consulta de arquivo com o id %d n\u00e3o retornou nada", id), 1, (Throwable)e);
        }
        catch (DownloadArquivoException e) {
            LOG.error("Erro na gera\u00e7\u00e3o do arquivo {} no Path {} via Stream. {}", new Object[]{id, path, e.getMessage(), e});
            throw new DownloadArquivoException(String.format("Erro na gera\u00e7\u00e3o do arquivo %d no Path %s via Stream.", id, path), (Exception)((Object)e));
        }
    }

    private void readResultSetBinaryStream(ResultSet rs, String filePath) {
        try (InputStream inputStream = rs.getBinaryStream("binary");
             FileOutputStream outputStream = new FileOutputStream(filePath);){
            int bytesRead;
            if (Objects.isNull(inputStream)) {
                throw new DownloadArquivoException("N\u00e3o encontrado conte\u00fado do arquivo.");
            }
            byte[] buffer = new byte[8192];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException | SQLException e) {
            throw new DownloadArquivoException("", e);
        }
    }

    public void deletarArquivo(Long id) {
        String sqlDeleteArquivo = "DELETE FROM ${eloarquivo}.ARQUIVO WHERE ID = ?";
        String sqlDeleteArquivoContent = "DELETE FROM ${eloarquivo}.ARQUIVO_CONTENT WHERE ID = ?";
        sqlDeleteArquivo = sqlDeleteArquivo.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        sqlDeleteArquivoContent = sqlDeleteArquivoContent.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        Object[] params = new Object[]{id};
        this.jdbcTemplate.update(sqlDeleteArquivoContent, params);
        this.jdbcTemplate.update(sqlDeleteArquivo, params);
    }

    public void updateContent(ProcessoArquivo processoArquivo, byte[] content) {
        String sqlUpdate = "UPDATE ${eloarquivo}.ARQUIVO_CONTENT SET ARQUIVO = ? WHERE ID = ?";
        sqlUpdate = sqlUpdate.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        this.jdbcTemplate.update(sqlUpdate, new Object[]{content, processoArquivo.getIdArquivo()});
    }

    public Boolean isFileCloud(Long idArquivo) {
        String sqlSelectArquivo = "SELECT fullpath FROM ${eloarquivo}.ARQUIVO WHERE ID = ?";
        sqlSelectArquivo = sqlSelectArquivo.replace(ELOARQUIVO_SCHEMA, this.schemaEloarqivo);
        try {
            String fullPath = (String)this.jdbcTemplate.queryForObject(sqlSelectArquivo, new Object[]{idArquivo}, String.class);
            return StringUtils.isNotBlank((CharSequence)fullPath);
        }
        catch (EmptyResultDataAccessException e) {
            LOG.error("Consulta de arquivo com o id {} n\u00e3o retornou nada. {}", new Object[]{idArquivo, e.getMessage(), e});
            return false;
        }
    }
}

