/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.domain.TramiteCountProjection;
import br.com.elotech.protocolo.domain.TramitePK;
import br.com.elotech.protocolo.dto.ParecerAuditDTO;
import br.com.elotech.protocolo.repository.TramiteRepositoryCustom;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface TramiteRepository
extends CrudRepository<Tramite, TramitePK>,
TramiteRepositoryCustom {
    @Query(value=" SELECT TREC.DATAREG AS INICIO,  TENC.DATAREG AS FIM FROM TRAMITACAO TREC JOIN USUARIO_LOCAL UL ON (UL.USUARIO = :usuario AND UL.LOCAL = TREC.LOCAL  AND UL.ENTIDADE = TREC.ENTIDADE) LEFT JOIN TRAMITACAO TENC ON (TREC.TIPO = TENC.TIPO     AND TREC.ANO = TENC.ANO     AND TREC.NUMERO = TENC.NUMERO     AND TREC.ENTIDADE = TENC.ENTIDADE     AND TREC.SEQUENCIA + 1 = TENC.SEQUENCIA) WHERE TREC.ENTIDADE = :entidade  AND TREC.FUNCAO = 'R' AND (TREC.DATAREG <> TENC.DATAREG OR TENC.DATAREG IS NULL) AND  UL.PADRAO = 'S' AND EXTRACT(YEAR FROM TREC.DATAREG) = :exercicio", nativeQuery=true)
    public List<Object[]> findIntervaloRecebidosAndEncaminhadosByExercicioAndUsuario(@Param(value="exercicio") Long var1, @Param(value="usuario") String var2, @Param(value="entidade") Long var3);

    @Query(value=" SELECT nextlotetramite(:entidade) AS NEXTID FROM ENTIDADE  WHERE ENTIDADE = :entidade ", nativeQuery=true)
    public Long findNextLote(@Param(value="entidade") Long var1);

    public Optional<Tramite> findByIdProcessoAndIdSequencia(Processo var1, Long var2);

    @Query(value="select t.funcao as funcao, count(*) as total from Tramite t  where t.dataRegistro between :inicio and :fim  and t.id.processo.id.entidade = :entidade and t.usuarioRegistro = :usuario  group by t.funcao")
    public Set<TramiteCountProjection> findTramitacoesByDataAndEntidade(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="entidade") Entidade var3, @Param(value="usuario") String var4);

    @Query(value="select t.entidade, t.numero, t.sequencia, t.tipo, t.ano, u.nome usuarioreg, t.hora datareg, t.parecer        from tramitacao_aud t        left join usuario u on u.login1 = case when t.usuarioalteracao is not null             then t.usuarioalteracao else t.usuarioreg end       where t.entidade = :entidade         and t.tipo = :tipo         and t.numero = :numero         and t.ano = :ano         and t.sequencia = :sequencia ", nativeQuery=true)
    public List<ParecerAuditDTO> listaAlteracaoParecer(@Param(value="numero") Long var1, @Param(value="tipo") Long var2, @Param(value="ano") Long var3, @Param(value="sequencia") Long var4, @Param(value="entidade") Long var5);
}

