/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.dto.ProcessoCaixaDTO;
import br.com.elotech.protocolo.dto.RequerimentoObservacaoProcessoAuditDTO;
import br.com.elotech.protocolo.enums.StatusAgrupamento;
import br.com.elotech.protocolo.repository.ProcessoCustomRepository;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ProcessoRepository
extends CrudRepository<Processo, ProcessoPK>,
ProcessoCustomRepository {
    public Boolean existsByUuid(String var1);

    @Query(value=" select p from Processo p  inner join Tramite t  on p.id.tipo.id = t.id.processo.id.tipo.id  and p.id.numero = t.id.processo.id.numero  and p.id.ano = t.id.processo.id.ano  and p.id.entidade.id = t.id.processo.id.entidade.id where t.lote = :lote and  t.id.sequencia = ( select max(tr.id.sequencia) from Tramite tr    where tr.id.processo.id.tipo.id = p.id.tipo.id  and tr.id.processo.id.numero = p.id.numero  and tr.id.processo.id.ano = p.id.ano  and tr.id.processo.id.entidade.id = p.id.entidade.id)")
    public List<Processo> findByTramiteLoteUltimoTramite(@Param(value="lote") Long var1);

    public Processo findOneByIdAnoAndIdTipoIdAndIdNumeroAndIdEntidadeIdAndPessoaCnpjCpf(Long var1, Long var2, Long var3, Long var4, String var5);

    public Page<Processo> findByPessoaIdOrderByDataProcessoDesc(Long var1, Pageable var2);

    public List<Processo> findByProcessoReferencia(String var1);

    public Processo findOneByIdAnoAndIdTipoIdAndIdNumero(Long var1, Long var2, Long var3);

    @Query(value=" select p from Processo p  left join p.pessoa pes  where p.id.ano = :ano and p.id.tipo.id = :idTipo and p.id.numero = :numero and  (pes.cnpjCpf = :cpfSenha or p.senhaInternet = :cpfSenha) ")
    public Processo findOneByAnoTipoNumeroAndSenhaOrCnpj(@Param(value="ano") Long var1, @Param(value="idTipo") Long var2, @Param(value="numero") Long var3, @Param(value="cpfSenha") String var4);

    @Query(value=" select p from Processo p  where p.id.ano = :ano and p.id.tipo.id = :idTipo and p.id.numero = :numero  and p.senhaInternet = :cpfSenha ")
    public Processo findOneByAnoTipoNumeroAndSenha(@Param(value="ano") Long var1, @Param(value="idTipo") Long var2, @Param(value="numero") Long var3, @Param(value="cpfSenha") String var4);

    @Query(value=" select p from Processo p  left join p.pessoa pes  where p.id.ano = :ano and p.id.tipo.id = :idTipo and p.id.numero = :numero and  (pes.cnpjCpf = :cpfSenha or p.senhaInternet = :cpfSenha) and p.id.entidade.id = :entidade ")
    public Processo findOneByAnoTipoNumeroAndSenhaOrCnpjAndEntidade(@Param(value="ano") Long var1, @Param(value="idTipo") Long var2, @Param(value="numero") Long var3, @Param(value="cpfSenha") String var4, @Param(value="entidade") Long var5);

    @Query(value=" select p from Processo p  where p.id.ano = :ano and p.id.tipo.id = :idTipo and p.id.numero = :numero and  p.senhaInternet = :cpfSenha and p.id.entidade.id = :entidade ")
    public Processo findOneByAnoTipoNumeroAndSenhaAndEntidade(@Param(value="ano") Long var1, @Param(value="idTipo") Long var2, @Param(value="numero") Long var3, @Param(value="cpfSenha") String var4, @Param(value="entidade") Long var5);

    public Processo findOneByIdAnoAndIdTipoIdAndIdNumeroAndIdEntidadeId(Long var1, Long var2, Long var3, Long var4);

    @Query(value=" select p from Processo p  where p.id.ano = :ano and p.id.tipo.id = :idTipo and p.id.numero = :numero and  p.id.entidade.id = :idEntidade and (p.localDestino in (:locais) or p.localOrigem in (:locais))")
    public Processo findOneByIdAnoAndIdTipoIdAndIdNumeroAndIdEntidadeIdAndLocaisIn(@Param(value="ano") Long var1, @Param(value="idTipo") Long var2, @Param(value="numero") Long var3, @Param(value="idEntidade") Long var4, @Param(value="locais") List<Local> var5);

    @Query(value="select p from Processo p  where p.assunto.id = :idAssunto   and p.pessoa.id = :idPessoa   and p.id.entidade.id = :idEntidade   and p.dataProcesso between :pDataIni and :pDataFim ")
    public List<Processo> findProcessoByAssuntoAndPessoaAndPeriodoDataProcesso(@Param(value="idEntidade") Long var1, @Param(value="idAssunto") Long var2, @Param(value="idPessoa") Long var3, @Param(value="pDataIni") LocalDate var4, @Param(value="pDataFim") LocalDate var5);

    @Query(value="SELECT COUNT(P.ENTIDADE)        FROM PROCESSOS P       INNER JOIN USUARIO_LOCAL UL ON UL.LOCAL = P.LOCALDESTINO AND UL.ENTIDADE = P.ENTIDADE       INNER JOIN USUARIO U ON U.LOGIN1 = UL.USUARIO       INNER JOIN USUARIO_TIPOSPROTOCOLO UTP ON UTP.USUARIO = UL.USUARIO AND UTP.TIPO = P.TIPO       WHERE P.ENTIDADE = :ENTIDADE         AND P.STATUS   = :STATUS         AND UL.USUARIO = :USUARIO         AND (P.IDPROCESSOTAXA IS NULL OR P.BOLETOPAGO = 'S') ", nativeQuery=true)
    public Long countProcessosByUsuario(@Param(value="ENTIDADE") Long var1, @Param(value="STATUS") Character var2, @Param(value="USUARIO") String var3);

    @Query(value="SELECT COUNT(P.ENTIDADE)        FROM PROCESSOS P       INNER JOIN USUARIO_LOCAL UL ON UL.LOCAL = P.LOCALDESTINO AND UL.ENTIDADE = P.ENTIDADE       INNER JOIN USUARIO U ON U.LOGIN1 = UL.USUARIO       WHERE P.ENTIDADE = :ENTIDADE         AND P.STATUS   = :STATUS         AND UL.USUARIO = :USUARIO         AND (P.IDPROCESSOTAXA IS NULL OR P.BOLETOPAGO = 'S') ", nativeQuery=true)
    public Long countProcessosByUsuarioIgnoreTipoProcesso(@Param(value="ENTIDADE") Long var1, @Param(value="STATUS") Character var2, @Param(value="USUARIO") String var3);

    @Query(value=" SELECT COUNT(P.ENTIDADE) FROM PROCESSOS P  LEFT JOIN usuario u ON      U.LOGIN1 = P.USUARIO_RESPONSAVEL_TRAMITE  LEFT JOIN usuario_entidade ue ON      UE.USUARIO = P.USUARIO_RESPONSAVEL_TRAMITE      AND UE.ENTIDADE = P.ENTIDADE  WHERE      P.ENTIDADE = :ENTIDADE      AND P.STATUS = :STATUS      AND P.USUARIO_RESPONSAVEL_TRAMITE = :USUARIO      AND (P.IDPROCESSOTAXA IS NULL OR P.BOLETOPAGO = 'S')      AND ( UE.ALTERATODOSPROC = 'S' OR EXISTS (              SELECT 1 FROM USUARIO_LOCAL UL              WHERE UL.LOCAL = P.LOCALDESTINO                AND UL.ENTIDADE = P.ENTIDADE                AND UL.USUARIO = P.USUARIO_RESPONSAVEL_TRAMITE) )", nativeQuery=true)
    public Long countProcessosByUsuarioParaUsuarioResponsavel(@Param(value="ENTIDADE") Long var1, @Param(value="STATUS") Character var2, @Param(value="USUARIO") String var3);

    @Query(value="SELECT COUNT(P.ENTIDADE)        FROM PROCESSOS P       WHERE P.ENTIDADE = :ENTIDADE         AND P.STATUS = :STATUS ", nativeQuery=true)
    public Long countProcessos(@Param(value="ENTIDADE") Long var1, @Param(value="STATUS") Character var2);

    @Modifying
    @Query(value=" update Processo set boletopago='S' where id.tipo.id = :TIPO   and id.ano = :ANO   and id.numero = :NUMERO   and id.entidade.id = :ENTIDADE")
    public void atualizaStatusBoletoParaPago(@Param(value="TIPO") Long var1, @Param(value="ANO") Long var2, @Param(value="NUMERO") Long var3, @Param(value="ENTIDADE") Long var4);

    public boolean existsByIdAndStatusAgrupamento(ProcessoPK var1, StatusAgrupamento var2);

    @Query(value=" select distinct new br.com.elotech.protocolo.dto.ProcessoCaixaDTO(p.id.numero,p.id.tipo.id,p.id.ano,p.id.entidade.id,t.data) from Processo p  inner join Tramite t  on p.id.tipo.id = t.id.processo.id.tipo.id  and p.id.numero = t.id.processo.id.numero  and p.id.ano = t.id.processo.id.ano  and p.id.entidade.id = t.id.processo.id.entidade.id  where t.caixa.id.codigo = :codigo  and  t.caixa.id.ano = :ano")
    public List<ProcessoCaixaDTO> getProcessosByCaixa(@Param(value="codigo") Long var1, @Param(value="ano") Long var2);

    @Query(value=" select p from Processo p where p.idIntegracaoAssinatura is not null ")
    public List<Processo> findAllProcessosIntegracaoAssinatura();

    @Query(value="select distinct t.entidade, t.numero, t.tipo, t.ano, u.nome usuarioreg, t.horaorigem datareg,                      t.digitacao as informacao, t.situacao||'-'|| s.descricao  as situacao        from processos_aud t        left join usuario u on u.login1 = t.usuarioalteracao        left join situacoes s on s.codigo = t.situacao       where t.entidade = :entidade         and t.tipo = :tipo         and t.numero = :numero         and t.ano = :ano         and t.digitacao is not null ", nativeQuery=true)
    public List<RequerimentoObservacaoProcessoAuditDTO> listaAlteracaoRequerimento(@Param(value="numero") Long var1, @Param(value="tipo") Long var2, @Param(value="ano") Long var3, @Param(value="entidade") Long var4);

    @Query(value="select distinct t.entidade, t.numero, t.tipo, t.ano, u.nome usuarioreg, t.horaorigem datareg,                      t.outrosdados as informacao, t.situacao||'-'|| s.descricao  as situacao        from processos_aud t        left join usuario u on u.login1 = t.usuarioalteracao        left join situacoes s on s.codigo = t.situacao       where t.entidade = :entidade         and t.tipo = :tipo         and t.numero = :numero         and t.ano = :ano         and t.outrosdados is not null ", nativeQuery=true)
    public List<RequerimentoObservacaoProcessoAuditDTO> listaAlteracaoObservacao(@Param(value="numero") Long var1, @Param(value="tipo") Long var2, @Param(value="ano") Long var3, @Param(value="entidade") Long var4);

    @Query(value="SELECT COUNT(P.ENTIDADE)        FROM PROCESSOS P       INNER JOIN USUARIO_LOCAL UL ON UL.LOCAL = P.LOCALDESTINO AND UL.ENTIDADE = P.ENTIDADE       INNER JOIN USUARIO U ON U.LOGIN1 = UL.USUARIO       INNER JOIN USUARIO_TIPOSPROTOCOLO UTP ON UTP.USUARIO = UL.USUARIO AND UTP.TIPO = P.TIPO       WHERE P.ENTIDADE = :ENTIDADE         AND P.STATUS   = :STATUS         AND UL.USUARIO = :USUARIO         AND (P.IDPROCESSOTAXA IS NULL OR P.BOLETOPAGO = 'S')         AND P.PARALISADO = :PARALISADO ", nativeQuery=true)
    public Long countProcessosByUsuarioAndParalisado(@Param(value="ENTIDADE") Long var1, @Param(value="STATUS") Character var2, @Param(value="USUARIO") String var3, @Param(value="PARALISADO") String var4);

    @Query(value="SELECT COUNT(P.ENTIDADE)        FROM PROCESSOS P       INNER JOIN USUARIO_LOCAL UL ON UL.LOCAL = P.LOCALDESTINO AND UL.ENTIDADE = P.ENTIDADE       INNER JOIN USUARIO U ON U.LOGIN1 = UL.USUARIO       WHERE P.ENTIDADE = :ENTIDADE         AND P.STATUS   = :STATUS         AND UL.USUARIO = :USUARIO         AND (P.IDPROCESSOTAXA IS NULL OR P.BOLETOPAGO = 'S')         AND P.PARALISADO = :PARALISADO ", nativeQuery=true)
    public Long countProcessosByUsuarioIgnoreTipoProcessoAndParalisado(@Param(value="ENTIDADE") Long var1, @Param(value="STATUS") Character var2, @Param(value="USUARIO") String var3, @Param(value="PARALISADO") String var4);

    @Query(value="SELECT COUNT(P.ENTIDADE)        FROM PROCESSOS P       WHERE P.ENTIDADE = :ENTIDADE         AND P.STATUS = :STATUS         AND P.PARALISADO = :PARALISADO ", nativeQuery=true)
    public Long countProcessosByParalisado(@Param(value="ENTIDADE") Long var1, @Param(value="STATUS") Character var2, @Param(value="PARALISADO") String var3);

    public Boolean existsByIdAnoAndIdTipoIdAndIdNumero(Long var1, Long var2, Long var3);

    @Query(value="select p from Processo p  where p.localDestino.id.entidade.id = :idEntidade   and p.id.tipo.id = :idTipo   and p.id.numero = :numero  and p.id.ano = :ano   and p.tramitaEntreEntidades = true ")
    public Processo findByProcessoByEntidadeTipoNumeroAno(@Param(value="idEntidade") Long var1, @Param(value="idTipo") Long var2, @Param(value="numero") Long var3, @Param(value="ano") Long var4);

    public Processo findByUuid(String var1);

    public boolean existsByIdAndStatusAgrupamentoIsNull(ProcessoPK var1);

    @Modifying
    @Query(value="UPDATE processos p SET statusagrupamento = :statusAgrupamento  WHERE p.entidade = :entidade and p.ano = :ano and p.tipo = :tipo and p.numero = :numero ", nativeQuery=true)
    public void updateStatusAgrupamentoById(@Param(value="statusAgrupamento") String var1, @Param(value="entidade") Long var2, @Param(value="ano") Long var3, @Param(value="tipo") Long var4, @Param(value="numero") Long var5);
}

