/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.protocolo.domain.ProcessoIntegracao;
import br.com.elotech.protocolo.enums.StatusIntegracaoEnum;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ProcessoIntegracaoRepository
extends CrudRepository<ProcessoIntegracao, Long> {
    public Page<ProcessoIntegracao> findAllByIntegradoIn(Set<StatusIntegracaoEnum> var1, Pageable var2);

    @Query(value="update ProcessoIntegracao pi\nset pi.integrado = :integrado,\n    pi.dataIntegracao = current_date\nwhere pi.idProcesso = :idProcesso\n  and pi.integrado = 'N'\n")
    @Modifying
    public void updateIntegradoByIdProcesso(@Param(value="idProcesso") String var1, @Param(value="integrado") StatusIntegracaoEnum var2);

    @Query(value="    select case when count(*) > 0 then 'true' else 'false' end\n    from ProcessoIntegracao pi\n    where pi.idProcesso = :idProcesso\n      and pi.integrado = 'N'\n")
    public boolean existsByIdProcessoAndIntegradoFalse(@Param(value="idProcesso") String var1);
}

